/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificOption;

public class DbSpecificConfig {
    private final String type;
    private String description;
    private final List<DbSpecificOption> options = new ArrayList<DbSpecificOption>();
    private final Config config = new Config();

    public DbSpecificConfig(String string) {
        this.type = string;
        try {
            Properties properties = this.config.determineDbProperties(string);
            this.description = properties.getProperty("description");
            this.loadOptions(properties);
        }
        catch (IOException iOException) {
            this.description = iOException.toString();
        }
    }

    private void loadOptions(Properties properties) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("connectionSpec"), "<>", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("<")) {
                bl = true;
                continue;
            }
            if (string.equals(">")) {
                bl = false;
                continue;
            }
            if (!bl) continue;
            String string2 = properties.getProperty(string);
            this.options.add(new DbSpecificOption(string, string2));
        }
    }

    public List<DbSpecificOption> getOptions() {
        return this.options;
    }

    public Config getConfig() {
        return this.config;
    }

    public void dumpUsage() {
        System.out.println(" " + new File(this.type).getName() + ":");
        System.out.println("  " + this.description);
        for (DbSpecificOption dbSpecificOption : this.getOptions()) {
            System.out.println("   -" + dbSpecificOption.getName() + " " + (String)(dbSpecificOption.getDescription() != null ? "  \t" + dbSpecificOption.getDescription() : ""));
        }
    }

    public String toString() {
        return this.description;
    }
}

