/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="linkField", parent="Uif-LinkField")
public class LinkField
extends FieldBase {
    private static final long serialVersionUID = -1908504471910271148L;
    private Link link;
    private String sortAs;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        if (StringUtils.isBlank((String)this.getLinkText())) {
            this.setLinkText(this.getLabel());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.getFieldLabel() != null && this.getLink() != null && StringUtils.isNotBlank((String)this.getLink().getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getLink().getId());
        }
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Link getLink() {
        return this.link;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    @BeanTagAttribute
    public String getLinkText() {
        return this.link.getLinkText();
    }

    public void setLinkText(String linkLabel) {
        this.link.setLinkText(linkLabel);
    }

    @BeanTagAttribute
    public String getLinkDialogId() {
        return this.link.getLinkDialogId();
    }

    public void setLinkDialogId(String linkDialogId) {
        this.link.setLinkDialogId(linkDialogId);
    }

    @BeanTagAttribute
    public boolean isOpenInDialog() {
        return this.link.isOpenInDialog();
    }

    public void setOpenInDialog(boolean openInDialog) {
        this.link.setOpenInDialog(openInDialog);
    }

    @BeanTagAttribute
    public String getTarget() {
        return this.link.getTarget();
    }

    public void setTarget(String target) {
        this.link.setTarget(target);
    }

    @BeanTagAttribute
    public String getHref() {
        return this.link.getHref();
    }

    public void setHref(String hrefText) {
        this.link.setHref(hrefText);
    }

    @BeanTagAttribute(name="sortAs")
    public String getSortAs() {
        return this.sortAs;
    }

    public void setSortAs(String sortAs) {
        if (!(sortAs.equals("kuali_date") || sortAs.equals("numeric") || sortAs.equals("string"))) {
            throw new IllegalArgumentException("invalid sortAs value of " + sortAs + ", allowed: kuali_date|numeric|string");
        }
        this.sortAs = sortAs;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getLink() == null && Validator.checkExpressions(this, "link")) {
            currentValues = new String[]{"link = " + this.getLink()};
            tracer.createError("Link should be set", currentValues);
        }
        if (this.getLabel() == null && Validator.checkExpressions(this, "label")) {
            currentValues = new String[]{"label =" + this.getLabel(), "link =" + this.getLink()};
            tracer.createWarning("Label is null, link should be used instead", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

