/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.export.RuleXmlExporter;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class RuleDelegationXmlExporter
implements XmlExporter {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.RULE_NAMESPACE);
    private RuleXmlExporter ruleExporter = new RuleXmlExporter(XmlConstants.RULE_NAMESPACE);

    public boolean supportPrettyPrint() {
        return true;
    }

    public Element export(ExportDataSet exportDataSet) {
        KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getRuleDelegations().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "ruleDelegations");
            rootElement.setAttribute("schemaLocation", "ns:workflow/Rule resource:Rule", XmlConstants.SCHEMA_NAMESPACE);
            for (RuleDelegationBo ruleDelegation : dataSet.getRuleDelegations()) {
                this.exportRuleDelegation(rootElement, ruleDelegation);
            }
            return rootElement;
        }
        return null;
    }

    private void exportRuleDelegation(Element parent, RuleDelegationBo ruleDelegation) {
        Element ruleDelegationElement = this.renderer.renderElement(parent, "ruleDelegation");
        this.exportParentResponsibility(ruleDelegationElement, ruleDelegation);
        this.renderer.renderTextElement(ruleDelegationElement, "delegationType", ruleDelegation.getDelegationType().getCode());
        this.ruleExporter.exportRule(ruleDelegationElement, ruleDelegation.getDelegationRule());
    }

    private void exportParentResponsibility(Element parent, RuleDelegationBo delegation) {
        Element parentResponsibilityElement = this.renderer.renderElement(parent, "parentResponsibility");
        RuleResponsibilityBo ruleResponsibility = KEWServiceLocator.getRuleService().findRuleResponsibility(delegation.getResponsibilityId());
        this.renderer.renderTextElement(parentResponsibilityElement, "parentRuleName", ruleResponsibility.getRuleBaseValues().getName());
        if (ruleResponsibility.isUsingPrincipal()) {
            Principal principal = ruleResponsibility.getPrincipal();
            this.renderer.renderTextElement(parentResponsibilityElement, "principalName", principal.getPrincipalName());
        } else if (ruleResponsibility.isUsingGroup()) {
            Group group = ruleResponsibility.getGroup();
            Element groupElement = this.renderer.renderElement(parentResponsibilityElement, "groupName");
            groupElement.setText(group.getName());
            groupElement.setAttribute("namespace", group.getNamespaceCode());
        } else if (ruleResponsibility.isUsingRole()) {
            this.renderer.renderTextElement(parentResponsibilityElement, "role", ruleResponsibility.getRuleResponsibilityName());
        } else {
            throw new RiceRuntimeException("Encountered a rule responsibility when exporting with an invalid type of '" + ruleResponsibility.getRuleResponsibilityType());
        }
    }
}

