/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.core.BudgetService;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.CostShare;
import org.kuali.coeus.common.budget.framework.core.ValidSourceAccountsCostShareType;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractBudgetService<T extends BudgetParent>
implements BudgetService<T> {
    private static final Logger LOG = LogManager.getLogger(AbstractBudgetService.class);
    public static final String BUDGET_ID = "budgetId";
    public static final String VALID_CE_RATE_TYPES = "validCeRateTypes";
    public static final String RATE_CLASS_TYPE = "rateClassType";
    public static final String ACTIVITY_TYPE_CODE = "activityTypeCode";
    public static final String ACTIVE = "active";
    public static final String COST_SHARE_TYPE = "costShareType";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;

    @Override
    public Budget addBudgetVersion(BudgetParentDocument<T> budgetParentDocument, String versionName, Map<String, Object> options) {
        if (!this.isBudgetVersionNameValid((BudgetParent)budgetParentDocument.getBudgetParent(), versionName)) {
            LOG.debug("Buffered Version not Valid");
            return null;
        }
        return this.getNewBudgetVersion(budgetParentDocument, versionName, options);
    }

    protected abstract Budget getNewBudgetVersion(BudgetParentDocument<T> var1, String var2, Map<String, Object> var3);

    @Override
    public boolean validInflationCeRate(BudgetLineItemBase budgetLineItem) {
        CostElement costElementBO = this.getCostElement(budgetLineItem.getCostElement());
        budgetLineItem.setCostElementBO(costElementBO);
        List<ValidCeRateType> validCeRateTypes = costElementBO.getValidCeRateTypes();
        QueryList qValidCeRateTypes = validCeRateTypes == null ? new QueryList() : new QueryList<ValidCeRateType>(validCeRateTypes);
        Equals eqInflation = new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.INFLATION.getRateClassType()));
        QueryList inflationValidCeRates = qValidCeRateTypes.filter(eqInflation);
        return !inflationValidCeRates.isEmpty();
    }

    protected CostElement getCostElement(String costElement) {
        CostElement costElementBO = (CostElement)this.businessObjectService.findBySinglePrimaryKey(CostElement.class, (Object)costElement);
        costElementBO.refreshReferenceObject(VALID_CE_RATE_TYPES);
        return costElementBO;
    }

    @Override
    public String getActivityTypeForBudget(Budget budget) {
        BudgetParent budgetParent = budget.getBudgetParent().getDocument().getBudgetParent();
        HashMap<String, Object> qMap = new HashMap<String, Object>();
        qMap.put(BUDGET_ID, budget.getBudgetId());
        List allPropRates = (List)this.businessObjectService.findMatching(BudgetRate.class, qMap);
        if (CollectionUtils.isNotEmpty((Collection)allPropRates)) {
            qMap.put(ACTIVITY_TYPE_CODE, budgetParent.getActivityTypeCode());
            Collection matchActivityTypePropRates = this.businessObjectService.findMatching(BudgetRate.class, qMap);
            if (CollectionUtils.isNotEmpty((Collection)matchActivityTypePropRates)) {
                for (BudgetRate budgetRate : allPropRates) {
                    if (budgetRate.getActivityTypeCode().equals(budgetParent.getActivityTypeCode())) continue;
                    return budgetRate.getActivityTypeCode();
                }
                return budgetParent.getActivityTypeCode();
            }
            return ((BudgetRate)allPropRates.get(0)).getActivityTypeCode();
        }
        return "x";
    }

    @Override
    public Collection<BudgetRate> getSavedProposalRates(Budget budgetToOpen) {
        HashMap<String, Long> qMap = new HashMap<String, Long>();
        qMap.put(BUDGET_ID, budgetToOpen.getBudgetId());
        return this.businessObjectService.findMatching(BudgetRate.class, qMap);
    }

    protected void copyLineItemToPersonnelDetails(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetPersonnelDetailsList() == null || budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) continue;
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.setBudget(budgetLineItem.getBudget());
                    budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
                    budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
                    budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
                    budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                    budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
                }
            }
        }
    }

    @Override
    public boolean isValidSourceAccountCostShareType(String validationMessageType, CostShare budgetCostShare, String costShareField) {
        boolean validMatches;
        Collection<ValidSourceAccountsCostShareType> activeValidSourceAccountCostSharetypes;
        boolean valid = Boolean.TRUE;
        if (this.isCostShareTypeSourceAccountValidationEnabled() && (activeValidSourceAccountCostSharetypes = this.getMatchingValidSourceAccountsCostShareTypes()).size() != 0 && !(validMatches = activeValidSourceAccountCostSharetypes.stream().anyMatch(validSourceAccountsCostShareType -> validSourceAccountsCostShareType.getCostShareTypeCode().equals(budgetCostShare.getCostShareTypeCode()) && budgetCostShare.getSourceAccount().equalsIgnoreCase(validSourceAccountsCostShareType.getAccount().getAccountNumber())))) {
            this.refreshReference(budgetCostShare);
            valid = this.addValidationMessage(validationMessageType, costShareField, "error.budget.distribution.costShare.costShareType.sourceAccount.invalid", budgetCostShare.getCostShareTypeCode() != null ? budgetCostShare.getCostShareType().getDescription() : "", budgetCostShare.getSourceAccount());
        }
        return valid;
    }

    public void refreshReference(CostShare budgetCostShare) {
        this.legacyDataAdapter.refreshReferenceObject((Object)budgetCostShare, COST_SHARE_TYPE);
    }

    public boolean isCostShareTypeSourceAccountValidationEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Enable_Cost_Share_Type_Source_Account_Validation");
    }

    public Collection<ValidSourceAccountsCostShareType> getMatchingValidSourceAccountsCostShareTypes() {
        HashMap<String, Boolean> fields = new HashMap<String, Boolean>();
        fields.put(ACTIVE, Boolean.TRUE);
        return this.getBusinessObjectService().findMatching(ValidSourceAccountsCostShareType.class, fields);
    }

    public boolean addValidationMessage(String validationMessageType, String field, String errorMessageKey, String ... errorParameters) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"E", (CharSequence)validationMessageType)) {
            this.getGlobalVariableService().getMessageMap().putError(field, errorMessageKey, errorParameters);
            return Boolean.FALSE;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"W", (CharSequence)validationMessageType)) {
            this.getGlobalVariableService().getMessageMap().putWarning(field, errorMessageKey, errorParameters);
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    protected boolean isBudgetFormulatedCostEnabled() {
        String formulatedCostEnabled = this.getParameterService().getParameterValueAsString(Budget.class, "enableFormulatedCostCalculation");
        return formulatedCostEnabled != null && formulatedCostEnabled.equalsIgnoreCase("Y");
    }

    protected List<String> getFormulatedCostElements() {
        String formulatedCEsValue = this.getParameterService().getParameterValueAsString(Budget.class, "formulatedCostElements");
        String[] formulatedCEs = formulatedCEsValue == null ? new String[]{} : formulatedCEsValue.split(",");
        return Arrays.asList(formulatedCEs);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public abstract GlobalVariableService getGlobalVariableService();

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

