/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.metadata.impl;

import com.google.common.annotations.Beta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataMergeAction;
import org.kuali.rice.krad.data.metadata.impl.DataObjectMetadataInternal;
import org.kuali.rice.krad.data.metadata.impl.MetadataCommonBase;
import org.kuali.rice.krad.data.metadata.impl.MetadataCommonInternal;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;

public class DataObjectMetadataImpl
extends MetadataCommonBase
implements DataObjectMetadataInternal {
    private static final long serialVersionUID = 7722982931510558892L;
    protected DataObjectMetadataInternal embedded;
    protected String providerName;
    protected Class<?> type;
    protected List<DataObjectAttribute> attributes;
    protected Map<String, DataObjectAttribute> attributeMap;
    protected List<String> removedAttributeNames;
    protected List<String> orderedAttributeList = new ArrayList<String>();
    protected List<DataObjectCollection> collections;
    protected Map<String, DataObjectCollection> collectionMap;
    protected List<String> removedCollectionNames;
    protected List<DataObjectRelationship> relationships;
    protected Map<String, DataObjectRelationship> relationshipMap;
    protected List<String> removedRelationshipNames;
    protected Map<String, List<DataObjectRelationship>> attributeToRelationshipMap;
    protected Map<String, DataObjectRelationship> lastAttributeToRelationshipMap;
    protected List<String> primaryKeyAttributeNames;
    protected List<String> businessKeyAttributeNames;
    protected String primaryDisplayAttributeName;
    protected boolean primaryDisplayAttributeSetManually;
    protected Boolean supportsOptimisticLocking;
    protected Collection<UifAutoCreateViewType> autoCreateUifViewTypes;
    List<DataObjectAttribute> mergedAttributes = null;

    @Override
    public Object getUniqueKeyForMerging() {
        return this.type;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("The data object type may not be set to null.");
        }
        this.type = type;
    }

    public String getTypeClassName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getName();
    }

    public void setTypeClassName(String typeClassName) {
        try {
            this.setType(Class.forName(typeClassName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("ClassNotFoundException when setting data object type class name " + typeClassName, e);
        }
    }

    @Override
    public List<String> getPrimaryKeyAttributeNames() {
        if (this.primaryKeyAttributeNames != null) {
            return this.primaryKeyAttributeNames;
        }
        if (this.embedded != null) {
            return this.embedded.getPrimaryKeyAttributeNames();
        }
        return Collections.emptyList();
    }

    public void setPrimaryKeyAttributeNames(List<String> primaryKeyAttributeNames) {
        if (primaryKeyAttributeNames == null) {
            primaryKeyAttributeNames = Collections.emptyList();
        }
        this.primaryKeyAttributeNames = Collections.unmodifiableList(primaryKeyAttributeNames);
    }

    @Override
    public List<String> getBusinessKeyAttributeNames() {
        if (this.businessKeyAttributeNames != null) {
            return this.businessKeyAttributeNames;
        }
        if (this.primaryKeyAttributeNames != null) {
            return this.primaryKeyAttributeNames;
        }
        if (this.embedded != null) {
            return this.embedded.getBusinessKeyAttributeNames();
        }
        return Collections.emptyList();
    }

    public void setBusinessKeyAttributeNames(List<String> businessKeyAttributeNames) {
        if (businessKeyAttributeNames == null) {
            businessKeyAttributeNames = Collections.emptyList();
        }
        this.businessKeyAttributeNames = Collections.unmodifiableList(businessKeyAttributeNames);
    }

    @Override
    public Boolean hasDistinctBusinessKey() {
        return !this.getPrimaryKeyAttributeNames().equals(this.getBusinessKeyAttributeNames());
    }

    @Override
    public String getPrimaryDisplayAttributeName() {
        if (this.primaryDisplayAttributeName == null && !this.getBusinessKeyAttributeNames().isEmpty()) {
            this.primaryDisplayAttributeName = this.getBusinessKeyAttributeNames().get(this.getBusinessKeyAttributeNames().size() - 1);
        }
        return this.primaryDisplayAttributeName;
    }

    public void setPrimaryDisplayAttributeName(String primaryDisplayAttributeName) {
        if (StringUtils.isBlank((String)primaryDisplayAttributeName)) {
            this.primaryDisplayAttributeName = null;
            this.primaryDisplayAttributeSetManually = false;
        } else {
            this.primaryDisplayAttributeName = primaryDisplayAttributeName;
            this.primaryDisplayAttributeSetManually = true;
        }
    }

    public List<DataObjectAttribute> orderAttributesByDefinedOrder(List<DataObjectAttribute> attributes) {
        ArrayList<DataObjectAttribute> sorted = new ArrayList<DataObjectAttribute>(attributes.size());
        HashMap<String, DataObjectAttribute> keyedAttributes = new HashMap<String, DataObjectAttribute>(attributes.size());
        HashMap<String, ArrayList<DataObjectAttribute>> inheritedAttributes = new HashMap<String, ArrayList<DataObjectAttribute>>();
        for (DataObjectAttribute attr : attributes) {
            if (attr.isInherited()) {
                ArrayList<DataObjectAttribute> inheritedByProperty = (ArrayList<DataObjectAttribute>)inheritedAttributes.get(attr.getInheritedFromParentAttributeName());
                if (inheritedByProperty == null) {
                    inheritedByProperty = new ArrayList<DataObjectAttribute>();
                    inheritedAttributes.put(attr.getInheritedFromParentAttributeName(), inheritedByProperty);
                }
                inheritedByProperty.add(attr);
                continue;
            }
            keyedAttributes.put(attr.getName(), attr);
        }
        for (Field f : this.getType().getDeclaredFields()) {
            DataObjectAttribute attr = (DataObjectAttribute)keyedAttributes.get(f.getName());
            if (attr != null) {
                sorted.add(attr);
                keyedAttributes.remove(f.getName());
            }
            if (!inheritedAttributes.containsKey(f.getName())) continue;
            sorted.addAll((Collection)inheritedAttributes.get(f.getName()));
        }
        sorted.addAll(keyedAttributes.values());
        return sorted;
    }

    @Override
    public List<DataObjectAttribute> getAttributes() {
        if (this.attributes != null && this.embedded == null) {
            return this.orderAttributesByDefinedOrder(this.attributes);
        }
        if (this.embedded != null) {
            return this.orderAttributesByDefinedOrder(this.mergeLists(this.embedded.getAttributes(), this.attributes));
        }
        return Collections.emptyList();
    }

    public void setAttributes(List<DataObjectAttribute> attributes) {
        if (attributes == null) {
            attributes = Collections.emptyList();
        }
        this.attributes = Collections.unmodifiableList(attributes);
        this.mergedAttributes = null;
        this.attributeMap = new HashMap<String, DataObjectAttribute>(attributes.size());
        this.removedAttributeNames = new ArrayList<String>();
        for (DataObjectAttribute attr : attributes) {
            if (attr.getMergeAction() != MetadataMergeAction.REMOVE && attr.getMergeAction() != MetadataMergeAction.NO_OVERRIDE) {
                this.attributeMap.put(attr.getName(), attr);
            }
            if (attr.getMergeAction() != MetadataMergeAction.REMOVE) continue;
            this.removedAttributeNames.add(attr.getName());
        }
    }

    @Override
    public List<DataObjectCollection> getCollections() {
        if (this.collections != null && this.embedded == null) {
            return this.collections;
        }
        if (this.embedded != null) {
            return this.mergeLists(this.embedded.getCollections(), this.collections);
        }
        return Collections.emptyList();
    }

    public void setCollections(List<DataObjectCollection> collections) {
        if (collections == null) {
            this.collections = null;
            return;
        }
        this.collections = Collections.unmodifiableList(collections);
        this.collectionMap = new HashMap<String, DataObjectCollection>(collections.size());
        this.removedCollectionNames = new ArrayList<String>();
        for (DataObjectCollection coll : collections) {
            if (coll.getMergeAction() != MetadataMergeAction.REMOVE && coll.getMergeAction() != MetadataMergeAction.NO_OVERRIDE) {
                this.collectionMap.put(coll.getName(), coll);
            }
            if (coll.getMergeAction() != MetadataMergeAction.REMOVE) continue;
            this.removedCollectionNames.add(coll.getName());
        }
    }

    @Override
    public List<DataObjectRelationship> getRelationships() {
        if (this.relationships != null && this.embedded == null) {
            return this.relationships;
        }
        if (this.embedded != null) {
            return this.mergeLists(this.embedded.getRelationships(), this.relationships);
        }
        return Collections.emptyList();
    }

    public void setRelationships(List<DataObjectRelationship> relationships) {
        if (relationships == null) {
            this.relationships = null;
            this.relationshipMap = null;
            this.lastAttributeToRelationshipMap = null;
            this.attributeToRelationshipMap = null;
            return;
        }
        this.relationships = Collections.unmodifiableList(relationships);
        this.relationshipMap = new HashMap<String, DataObjectRelationship>(relationships.size());
        this.attributeToRelationshipMap = new HashMap<String, List<DataObjectRelationship>>();
        this.lastAttributeToRelationshipMap = new HashMap<String, DataObjectRelationship>(relationships.size());
        this.removedRelationshipNames = new ArrayList<String>();
        for (DataObjectRelationship rel : relationships) {
            if (rel.getMergeAction() != MetadataMergeAction.REMOVE && rel.getMergeAction() != MetadataMergeAction.NO_OVERRIDE) {
                this.relationshipMap.put(rel.getName(), rel);
                if (!rel.getAttributeRelationships().isEmpty()) {
                    DataObjectAttributeRelationship relAttr = rel.getAttributeRelationships().get(0);
                    this.lastAttributeToRelationshipMap.put(relAttr.getParentAttributeName(), rel);
                }
                for (DataObjectAttributeRelationship relAttr : rel.getAttributeRelationships()) {
                    List<DataObjectRelationship> rels = this.attributeToRelationshipMap.get(relAttr.getParentAttributeName());
                    if (rels == null) {
                        rels = new ArrayList<DataObjectRelationship>();
                        this.attributeToRelationshipMap.put(relAttr.getParentAttributeName(), rels);
                    }
                    rels.add(rel);
                }
            }
            if (rel.getMergeAction() != MetadataMergeAction.REMOVE) continue;
            this.removedRelationshipNames.add(rel.getName());
        }
        this.relationshipMap = Collections.unmodifiableMap(this.relationshipMap);
        this.lastAttributeToRelationshipMap = Collections.unmodifiableMap(this.lastAttributeToRelationshipMap);
        this.attributeToRelationshipMap = Collections.unmodifiableMap(this.attributeToRelationshipMap);
    }

    @Override
    public DataObjectAttribute getAttribute(String attributeName) {
        if (attributeName == null) {
            return null;
        }
        DataObjectAttribute attribute = null;
        if (this.attributes != null) {
            attribute = this.attributeMap.get(attributeName);
        }
        if (attribute == null && this.embedded != null && (attribute = this.embedded.getAttribute(attributeName)) != null && this.removedAttributeNames != null && this.removedAttributeNames.contains(attribute.getName())) {
            attribute = null;
        }
        return attribute;
    }

    @Override
    public DataObjectCollection getCollection(String collectionName) {
        if (collectionName == null) {
            return null;
        }
        DataObjectCollection collection = null;
        if (this.collections != null) {
            collection = this.collectionMap.get(collectionName);
        }
        if (collection == null && this.embedded != null && (collection = this.embedded.getCollection(collectionName)) != null && this.removedCollectionNames != null && this.removedCollectionNames.contains(collection.getName())) {
            collection = null;
        }
        return collection;
    }

    @Override
    public DataObjectRelationship getRelationship(String relationshipName) {
        if (relationshipName == null) {
            return null;
        }
        DataObjectRelationship relationship = null;
        if (this.relationships != null) {
            relationship = this.relationshipMap.get(relationshipName);
        }
        if (relationship == null && this.embedded != null && (relationship = this.embedded.getRelationship(relationshipName)) != null && this.removedRelationshipNames != null && this.removedRelationshipNames.contains(relationship.getName())) {
            relationship = null;
        }
        return relationship;
    }

    @Override
    public List<DataObjectRelationship> getRelationshipsInvolvingAttribute(String attributeName) {
        Object mergeKey;
        if (StringUtils.isBlank((String)attributeName)) {
            return null;
        }
        HashMap<Object, DataObjectRelationship> relationships = new HashMap<Object, DataObjectRelationship>();
        if (this.attributeToRelationshipMap != null && this.attributeToRelationshipMap.containsKey(attributeName)) {
            for (DataObjectRelationship rel : this.attributeToRelationshipMap.get(attributeName)) {
                mergeKey = rel.getName();
                if (rel instanceof MetadataCommonInternal) {
                    mergeKey = ((MetadataCommonInternal)((Object)rel)).getUniqueKeyForMerging();
                }
                relationships.put(mergeKey, rel);
            }
        }
        if (this.embedded != null) {
            for (DataObjectRelationship rel : this.embedded.getRelationshipsInvolvingAttribute(attributeName)) {
                mergeKey = rel.getName();
                if (rel instanceof MetadataCommonInternal) {
                    mergeKey = ((MetadataCommonInternal)((Object)rel)).getUniqueKeyForMerging();
                }
                if (relationships.containsKey(mergeKey)) continue;
                relationships.put(mergeKey, rel);
            }
        }
        return new ArrayList<DataObjectRelationship>(relationships.values());
    }

    @Override
    public DataObjectRelationship getRelationshipByLastAttributeInRelationship(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            return null;
        }
        DataObjectRelationship relationship = null;
        if (this.lastAttributeToRelationshipMap != null) {
            relationship = this.lastAttributeToRelationshipMap.get(attributeName);
        }
        if (relationship == null && this.embedded != null) {
            relationship = this.embedded.getRelationshipByLastAttributeInRelationship(attributeName);
        }
        return relationship;
    }

    @Override
    public DataObjectMetadataInternal getEmbedded() {
        return this.embedded;
    }

    @Override
    public void setEmbedded(DataObjectMetadataInternal embedded) {
        this.embedded = embedded;
        this.setEmbeddedCommonMetadata(embedded);
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataObjectMetadata [");
        builder.append("type=").append(this.getType()).append(", ");
        builder.append("typeLabel=").append(this.label).append(", ");
        builder.append("backingObjectName=").append(this.backingObjectName);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.append(", ").append("attributes=").append(this.attributes);
        }
        if (this.primaryKeyAttributeNames != null && !this.primaryKeyAttributeNames.isEmpty()) {
            builder.append(", ").append("primaryKeyAttributeNames=").append(this.primaryKeyAttributeNames);
        }
        if (this.getPrimaryDisplayAttributeName() != null) {
            builder.append(", ").append("primaryDisplayAttributeName=").append(this.getPrimaryDisplayAttributeName());
        }
        if (this.businessKeyAttributeNames != null && !this.businessKeyAttributeNames.isEmpty()) {
            builder.append(", ").append("businessKeyAttributeNames=").append(this.businessKeyAttributeNames);
        }
        if (this.collections != null && !this.collections.isEmpty()) {
            builder.append(", ").append("collections=").append(this.collections);
        }
        if (this.relationships != null && !this.relationships.isEmpty()) {
            builder.append(", ").append("relationships=").append(this.relationships);
        }
        if (this.providerName != null) {
            builder.append(", ").append("providerName=").append(this.providerName);
        }
        if (this.embedded != null) {
            builder.append(", ").append("mergeAction=").append((Object)this.mergeAction);
            builder.append(", ").append("embedded=").append(this.embedded);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isSupportsOptimisticLocking() {
        if (this.supportsOptimisticLocking != null) {
            return this.supportsOptimisticLocking;
        }
        if (this.embedded != null) {
            return this.embedded.isSupportsOptimisticLocking();
        }
        return false;
    }

    public void setSupportsOptimisticLocking(boolean supportsOptimisticLocking) {
        this.supportsOptimisticLocking = supportsOptimisticLocking;
    }

    @Override
    @Beta
    public boolean shouldAutoCreateUifViewOfType(UifAutoCreateViewType viewType) {
        if (this.getAutoCreateUifViewTypes() == null) {
            return false;
        }
        return this.getAutoCreateUifViewTypes().contains((Object)viewType) || this.getAutoCreateUifViewTypes().contains((Object)UifAutoCreateViewType.ALL);
    }

    @Override
    @Beta
    public Collection<UifAutoCreateViewType> getAutoCreateUifViewTypes() {
        if (this.autoCreateUifViewTypes != null) {
            return this.autoCreateUifViewTypes;
        }
        if (this.embedded != null) {
            return this.embedded.getAutoCreateUifViewTypes();
        }
        return null;
    }

    @Beta
    public void setAutoCreateUifViewTypes(Collection<UifAutoCreateViewType> autoCreateUifViewTypes) {
        this.autoCreateUifViewTypes = autoCreateUifViewTypes;
    }

    public List<String> getOrderedAttributeList() {
        return this.orderedAttributeList;
    }

    public void setOrderedAttributeList(List<String> orderedAttributeList) {
        this.orderedAttributeList = orderedAttributeList;
    }
}

