/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.LifecycleEventListener;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="quickFinder", parent="Uif-QuickFinder"), @BeanTag(name="quickFinderByScript", parent="Uif-QuickFinderByScript"), @BeanTag(name="collectionQuickFinder", parent="Uif-CollectionQuickFinder")})
public class QuickFinder
extends WidgetBase
implements LifecycleEventListener {
    private static final long serialVersionUID = 3302390972815386785L;
    private String baseLookupUrl;
    private String dataObjectClassName;
    private String viewName;
    private boolean returnByScript;
    private String readOnlyLookupFields;
    private String referencesToRefresh;
    private String lookupCollectionName;
    private String lookupCollectionId;
    private Map<String, String> fieldConversions = new HashMap<String, String>();
    private Map<String, String> lookupParameters = new HashMap<String, String>();
    private Map<String, String> additionalLookupParameters;
    private Action quickfinderAction;
    private String lookupDialogId = "";
    private boolean openInDialog;
    private Boolean renderReturnLink;
    private Boolean renderResultActions;
    private Boolean autoSearch;
    private Boolean renderLookupCriteria;
    private Boolean renderCriteriaActions;
    private Boolean hideCriteriaOnSearch;
    private Boolean renderMaintenanceLinks;
    private Boolean multipleValuesSelect;
    private String callbackMethodToCall;
    private MethodInvokerConfig callbackMethod;
    private Map<String, String> callbackContext;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        ViewLifecycle viewLifecycle = ViewLifecycle.getActiveLifecycle();
        viewLifecycle.registerLifecycleCompleteListener(this.quickfinderAction, this);
    }

    @Override
    public void afterEvaluateExpression() {
        super.afterEvaluateExpression();
        if (this.getReadOnly() == null) {
            Component parent = ViewLifecycle.getPhase().getParent();
            this.setReadOnly(parent == null ? null : parent.getReadOnly());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (parent instanceof Component && Boolean.TRUE.equals(((Component)parent).getReadOnly())) {
            this.setRender(false);
        }
        if (!this.isRender()) {
            return;
        }
        ViewLifecycle.getActiveLifecycle();
        View view = ViewLifecycle.getView();
        if (parent instanceof InputField) {
            this.setupForInputField(view, model, (InputField)parent);
            if (this.isRender()) {
                for (String toField : this.fieldConversions.values()) {
                    ViewLifecycle.getViewPostMetadata().addAccessibleBindingPath(toField);
                }
            }
        } else if (parent instanceof CollectionGroup) {
            this.setupForCollectionGroup(view, model, (CollectionGroup)parent);
        }
        this.setupQuickfinderAction(view, model, parent);
        this.addCallbackParametersIfPresent();
    }

    protected void setupForInputField(View view, Object model, InputField inputField) {
        if (StringUtils.isBlank((String)this.dataObjectClassName)) {
            DataObjectRelationship relationship = this.getRelationshipForField(view, model, inputField);
            if (relationship == null) {
                this.setRender(false);
                return;
            }
            this.dataObjectClassName = relationship.getRelatedClass().getName();
            if (this.fieldConversions == null || this.fieldConversions.isEmpty()) {
                this.generateFieldConversions(relationship);
            }
            if (this.lookupParameters == null || this.lookupParameters.isEmpty()) {
                this.generateLookupParameters(relationship);
            }
        }
        this.updateFieldConversions(inputField.getBindingInfo());
        this.updateLookupParameters(inputField.getBindingInfo());
        this.updateReferencesToRefresh(inputField.getBindingInfo());
        inputField.addPostInputAddon(this.quickfinderAction);
    }

    protected DataObjectRelationship getRelationshipForField(View view, Object model, InputField field) {
        String propertyName = field.getBindingInfo().getBindingName();
        Object parentObject = ViewModelUtils.getParentObjectForMetadata(view, model, field);
        Class<?> parentObjectClass = null;
        if (parentObject != null) {
            parentObjectClass = parentObject.getClass();
        }
        if (parentObjectClass != null) {
            return KRADServiceLocatorWeb.getLegacyDataAdapter().getDataObjectRelationship(parentObject, parentObjectClass, propertyName, "", true, true, false);
        }
        return null;
    }

    protected void generateFieldConversions(DataObjectRelationship relationship) {
        this.fieldConversions = new HashMap<String, String>();
        for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = (String)entry.getValue();
            String toField = (String)entry.getKey();
            this.fieldConversions.put(fromField, toField);
        }
    }

    protected void generateLookupParameters(DataObjectRelationship relationship) {
        this.lookupParameters = new HashMap<String, String>();
        for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = (String)entry.getKey();
            String toField = (String)entry.getValue();
            if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
            this.lookupParameters.put(fromField, toField);
        }
    }

    protected void updateFieldConversions(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedFieldConversions = new HashMap<String, String>();
        for (String fromField : this.fieldConversions.keySet()) {
            String toField = this.fieldConversions.get(fromField);
            if (!StringUtils.startsWith((String)toField, (String)bindingInfo.getBindingPathPrefix())) {
                String adjustedToFieldPath = bindingInfo.getPropertyAdjustedBindingPath(toField);
                adjustedFieldConversions.put(fromField, adjustedToFieldPath);
                continue;
            }
            adjustedFieldConversions.put(fromField, toField);
        }
        this.fieldConversions = adjustedFieldConversions;
    }

    protected void updateLookupParameters(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedLookupParameters = new HashMap<String, String>();
        for (String fromField : this.lookupParameters.keySet()) {
            String toField = this.lookupParameters.get(fromField);
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(fromField);
            adjustedLookupParameters.put(adjustedFromFieldPath, toField);
        }
        this.lookupParameters = adjustedLookupParameters;
    }

    protected void updateReferencesToRefresh(BindingInfo bindingInfo) {
        ArrayList<String> adjustedReferencesToRefresh = new ArrayList<String>();
        if (this.referencesToRefresh == null) {
            this.referencesToRefresh = new String();
        }
        for (String reference : StringUtils.split((String)this.referencesToRefresh, (String)",")) {
            adjustedReferencesToRefresh.add(bindingInfo.getPropertyAdjustedBindingPath(reference));
        }
        this.referencesToRefresh = StringUtils.join(adjustedReferencesToRefresh, (String)",");
    }

    protected void setupForCollectionGroup(View view, Object model, CollectionGroup collectionGroup) {
        if (StringUtils.isBlank((String)this.getDataObjectClassName())) {
            Class<?> collectionObjectClass = collectionGroup.getCollectionObjectClass();
            boolean isCollectionClassLookupable = KRADServiceLocatorWeb.getViewDictionaryService().isLookupable(collectionObjectClass);
            if (isCollectionClassLookupable) {
                this.setDataObjectClassName(collectionObjectClass.getName());
                if (this.fieldConversions == null || this.fieldConversions.isEmpty()) {
                    List collectionObjectPKFields = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(collectionObjectClass);
                    this.fieldConversions = new HashMap<String, String>();
                    for (String pkField : collectionObjectPKFields) {
                        this.fieldConversions.put(pkField, pkField);
                    }
                }
            } else {
                this.setRender(false);
            }
        }
        if (this.isRender() && StringUtils.isBlank((String)this.getLookupCollectionName())) {
            this.setLookupCollectionName(collectionGroup.getBindingInfo().getBindingPath());
        }
        if (this.isRender() && StringUtils.isBlank((String)this.getLookupCollectionId())) {
            this.setLookupCollectionId(collectionGroup.getId());
        }
    }

    protected void setupQuickfinderAction(View view, Object model, LifecycleElement parent) {
        Class<ExternalizableBusinessObject> implementationClass;
        this.quickfinderAction.setId(this.getId() + "_act");
        if (parent instanceof InputField) {
            String label = "Search for " + ((InputField)parent).getLabel();
            this.quickfinderAction.setTitle(label);
            this.quickfinderAction.addAriaAttribute("label", label);
        }
        if (this.openInDialog) {
            Object superParent;
            String[] dialogIds;
            UifFormBase form;
            Map<String, String[]> requestParameters;
            String dialogId;
            String lightboxScript = null;
            String actionScript = this.quickfinderAction.getActionScript();
            if (actionScript == null) {
                actionScript = "";
            }
            if (StringUtils.isBlank((String)(dialogId = this.quickfinderAction.getActionParameter("dialogId"))) && (requestParameters = (form = (UifFormBase)model).getInitialRequestParameters()) != null && (dialogIds = requestParameters.get("dialogId")) != null && dialogIds.length > 0) {
                dialogId = dialogIds[0];
            }
            if (StringUtils.isBlank((String)dialogId) && (superParent = parent.getContext().get("parent")) != null) {
                FieldGroup parentFieldGroup;
                CollectionGroup parentCollection;
                if (superParent instanceof DialogGroup) {
                    dialogId = ((DialogGroup)superParent).getId();
                } else if (superParent instanceof CollectionGroup && (superParent = (parentCollection = (CollectionGroup)superParent).getContext().get("parent")) instanceof FieldGroup && (superParent = (parentFieldGroup = (FieldGroup)superParent).getContext().get("parent")) instanceof DialogGroup) {
                    dialogId = ((DialogGroup)superParent).getId();
                }
            }
            if (StringUtils.isBlank((String)dialogId)) {
                lightboxScript = "showLookupDialog(\"" + this.quickfinderAction.getId() + "\"," + this.returnByScript + ",\"" + this.lookupDialogId + "\");";
            } else {
                lightboxScript = "showLookupDialog(\"" + this.quickfinderAction.getId() + "\"," + this.returnByScript + ",\"" + this.lookupDialogId + "\",\"" + dialogId + "\");";
                this.quickfinderAction.addActionParameter("dialogId", dialogId);
            }
            this.quickfinderAction.setActionScript(actionScript + lightboxScript);
        }
        this.quickfinderAction.addActionParameter("baseLookupUrl", this.baseLookupUrl);
        Class<?> dataObjectClass = this.getDataObjectClass(this.dataObjectClassName);
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(dataObjectClass);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(dataObjectClass) && ExternalizableBusinessObject.class.isAssignableFrom(dataObjectClass) && (implementationClass = responsibleModuleService.getExternalizableBusinessObjectImplementation(dataObjectClass.asSubclass(ExternalizableBusinessObject.class))) != null) {
            this.dataObjectClassName = implementationClass.getName();
        }
        this.quickfinderAction.addActionParameter("dataObjectClassName", this.dataObjectClassName);
        if (!this.fieldConversions.isEmpty()) {
            this.quickfinderAction.addActionParameter("conversionFields", KRADUtils.buildMapParameterString(this.fieldConversions));
        }
        if (!this.lookupParameters.isEmpty()) {
            this.quickfinderAction.addActionParameter("lookupParameters", KRADUtils.buildMapParameterString(this.lookupParameters));
        }
        this.addActionParameterIfNotNull("viewName", this.viewName);
        this.addActionParameterIfNotNull("readOnlyFields", this.readOnlyLookupFields);
        this.addActionParameterIfNotNull("renderReturnLink", this.renderReturnLink);
        this.addActionParameterIfNotNull("renderResultActions", this.renderResultActions);
        this.addActionParameterIfNotNull("referencesToRefresh", this.referencesToRefresh);
        this.addActionParameterIfNotNull("autoSearch", this.autoSearch);
        this.addActionParameterIfNotNull("renderlookupCriteria", this.renderLookupCriteria);
        this.addActionParameterIfNotNull("renderCriteriaActions", this.renderCriteriaActions);
        this.addActionParameterIfNotNull("hideCriteriaOnSearch", this.hideCriteriaOnSearch);
        this.addActionParameterIfNotNull("renderMaintenanceLinks", this.renderMaintenanceLinks);
        this.addActionParameterIfNotNull("multipleValuesSelect", this.multipleValuesSelect);
        this.addActionParameterIfNotNull("lookupCollectionName", this.lookupCollectionName);
        this.addActionParameterIfNotNull("lookupCollectionId", this.lookupCollectionId);
        this.addActionParameterIfNotNull("quickfinderId", this.getId());
        if (this.additionalLookupParameters != null) {
            Map<String, String> actionParameters = this.quickfinderAction.getActionParameters();
            actionParameters.putAll(this.additionalLookupParameters);
            this.quickfinderAction.setActionParameters(actionParameters);
        }
        this.quickfinderAction.performFinalize(model, parent);
    }

    private Class<?> getDataObjectClass(String className) {
        Class<?> dataObjectClass;
        try {
            dataObjectClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to get class for name: " + className, e);
        }
        return dataObjectClass;
    }

    protected void addActionParameterIfNotNull(String parameterName, Object parameterValue) {
        if (parameterValue != null && StringUtils.isNotBlank((String)parameterValue.toString())) {
            this.quickfinderAction.addActionParameter(parameterName, parameterValue.toString());
        }
    }

    @Override
    public void processEvent(ViewLifecycle.LifecycleEvent lifecycleEvent, View view, Object model, LifecycleElement eventComponent) {
        Action finalQuickfinderAction = (Action)eventComponent;
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "quickfinderFocusId", (Object)finalQuickfinderAction.getFocusOnIdAfterSubmit());
        ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "quickfinderJumpToId", (Object)finalQuickfinderAction.getJumpToIdAfterSubmit());
    }

    protected void addCallbackParametersIfPresent() {
        if (StringUtils.isNotBlank((String)this.callbackMethodToCall)) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "quickfinderCallbackMethodToCall", (Object)this.callbackMethodToCall);
        }
        if (this.callbackMethod != null) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "quickfinderCallbackMethod", (Object)this.callbackMethod);
        }
        if (this.callbackContext != null && !this.callbackContext.isEmpty()) {
            ViewLifecycle.getViewPostMetadata().addComponentPostData(this, "quickfinderCallbackContext", this.callbackContext);
        }
    }

    @BeanTagAttribute
    public String getBaseLookupUrl() {
        return this.baseLookupUrl;
    }

    public void setBaseLookupUrl(String baseLookupUrl) {
        this.baseLookupUrl = baseLookupUrl;
    }

    @BeanTagAttribute
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @BeanTagAttribute
    public boolean isReturnByScript() {
        return this.returnByScript;
    }

    public void setReturnByScript(boolean returnByScript) {
        this.returnByScript = returnByScript;
    }

    @BeanTagAttribute
    public String getReadOnlyLookupFields() {
        return this.readOnlyLookupFields;
    }

    public void setReadOnlyLookupFields(String readOnlyLookupFields) {
        this.readOnlyLookupFields = readOnlyLookupFields;
    }

    @BeanTagAttribute
    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    public void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    @BeanTagAttribute
    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    @BeanTagAttribute
    public Map<String, String> getLookupParameters() {
        return this.lookupParameters;
    }

    public void setLookupParameters(Map<String, String> lookupParameters) {
        this.lookupParameters = lookupParameters;
    }

    @BeanTagAttribute
    public Boolean getRenderReturnLink() {
        return this.renderReturnLink;
    }

    public void setRenderReturnLink(Boolean renderReturnLink) {
        this.renderReturnLink = renderReturnLink;
    }

    @BeanTagAttribute
    public Boolean getRenderResultActions() {
        return this.renderResultActions;
    }

    public void setRenderResultActions(Boolean renderResultActions) {
        this.renderResultActions = renderResultActions;
    }

    @BeanTagAttribute
    public Boolean getAutoSearch() {
        return this.autoSearch;
    }

    public void setAutoSearch(Boolean autoSearch) {
        this.autoSearch = autoSearch;
    }

    @BeanTagAttribute
    public Boolean getRenderLookupCriteria() {
        return this.renderLookupCriteria;
    }

    public void setRenderLookupCriteria(Boolean renderLookupCriteria) {
        this.renderLookupCriteria = renderLookupCriteria;
    }

    @BeanTagAttribute
    public Boolean getRenderCriteriaActions() {
        return this.renderCriteriaActions;
    }

    public void setRenderCriteriaActions(Boolean renderCriteriaActions) {
        this.renderCriteriaActions = renderCriteriaActions;
    }

    @BeanTagAttribute
    public Boolean getHideCriteriaOnSearch() {
        return this.hideCriteriaOnSearch;
    }

    public void setHideCriteriaOnSearch(Boolean hideCriteriaOnSearch) {
        this.hideCriteriaOnSearch = hideCriteriaOnSearch;
    }

    @BeanTagAttribute
    public Boolean getRenderMaintenanceLinks() {
        return this.renderMaintenanceLinks;
    }

    public void setRenderMaintenanceLinks(Boolean renderMaintenanceLinks) {
        this.renderMaintenanceLinks = renderMaintenanceLinks;
    }

    @ViewLifecycleRestriction(exclude={"FINALIZE"})
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.BYTYPE)
    public Action getQuickfinderAction() {
        return this.quickfinderAction;
    }

    public void setQuickfinderAction(Action quickfinderAction) {
        this.quickfinderAction = quickfinderAction;
    }

    @BeanTagAttribute
    public String getLookupDialogId() {
        return this.lookupDialogId;
    }

    public void setLookupDialogId(String lookupDialogId) {
        this.lookupDialogId = lookupDialogId;
    }

    @BeanTagAttribute
    public boolean isOpenInDialog() {
        return this.openInDialog;
    }

    public void setOpenInDialog(boolean openInDialog) {
        this.openInDialog = openInDialog;
    }

    @BeanTagAttribute
    public Boolean getMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(Boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    @BeanTagAttribute
    public String getLookupCollectionName() {
        return this.lookupCollectionName;
    }

    public void setLookupCollectionName(String lookupCollectionName) {
        this.lookupCollectionName = lookupCollectionName;
    }

    @BeanTagAttribute
    public String getLookupCollectionId() {
        return this.lookupCollectionId;
    }

    public void setLookupCollectionId(String lookupCollectionId) {
        this.lookupCollectionId = lookupCollectionId;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalLookupParameters() {
        return this.additionalLookupParameters;
    }

    public void setAdditionalLookupParameters(Map<String, String> additionalLookupParameters) {
        this.additionalLookupParameters = additionalLookupParameters;
    }

    public String getCallbackMethodToCall() {
        return this.callbackMethodToCall;
    }

    public void setCallbackMethodToCall(String callbackMethodToCall) {
        this.callbackMethodToCall = callbackMethodToCall;
    }

    public MethodInvokerConfig getCallbackMethod() {
        return this.callbackMethod;
    }

    public void setCallbackMethod(MethodInvokerConfig callbackMethod) {
        this.callbackMethod = callbackMethod;
    }

    public Map<String, String> getCallbackContext() {
        return this.callbackContext;
    }

    public void setCallbackContext(Map<String, String> callbackContext) {
        this.callbackContext = callbackContext;
    }
}

