--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

  CREATE TABLE cx_hrapi_import_status (
    importId                VARCHAR2(50) NOT NULL PRIMARY KEY,
    status                  VARCHAR2(20) DEFAULT 'PROCESSING' NOT NULL,
    startTime               NUMBER(19, 0) NOT NULL,
    endTime                 NUMBER(19, 0) DEFAULT -1,
    numRecords              INT DEFAULT 0,
    numProcessed            INT DEFAULT 0,
    detail                  CLOB
  );

  CREATE SEQUENCE SEQ_CX_HRAPI_ERROR_ID INCREMENT BY 1 START WITH 1 NOCACHE;

  CREATE TABLE cx_hrapi_import_errors (
    errorId                 INT PRIMARY KEY,
    importId                VARCHAR2(50) NOT NULL,
    recordNum               INT,
    principalName           VARCHAR2(100),
    exception               BLOB,

    CONSTRAINT FK_IMPORT FOREIGN KEY (importId)
    REFERENCES cx_hrapi_import_status(importId)
    ON DELETE CASCADE
  );

  CREATE TABLE cx_hrapi_import_persons (
    personId                VARCHAR2(40) PRIMARY KEY NOT NULL,
    importId                VARCHAR2(50) NOT NULL,
    recordStatus            VARCHAR2(8) DEFAULT 'ADDED' NOT NULL,

    CONSTRAINT FK_cx_hrapi_import_status FOREIGN KEY (importId)
    REFERENCES cx_hrapi_import_status(importId)
    ON DELETE CASCADE
  );

