/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Map;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerTransientImpl;

public class IdentityFactoryImpl
implements IdentityFactory,
PBStateListener {
    private PersistenceBroker broker;
    private Map objectToIdentityMap;
    private SequenceManager transientSequenceManager;

    public IdentityFactoryImpl(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
        this.objectToIdentityMap = new ReferenceIdentityMap(2, 0, true);
        this.transientSequenceManager = new SequenceManagerTransientImpl(persistenceBroker);
        persistenceBroker.addListener(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Identity createTransientOrRealIdentity(ClassDescriptor classDescriptor, Object object) {
        if (object == null) {
            throw new OJBRuntimeException("Can't create Identity for 'null'-object");
        }
        Identity identity = null;
        Class clazz = null;
        Class<?> clazz2 = null;
        Object[] objectArray = null;
        try {
            IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
            Object object2 = object;
            synchronized (object2) {
                if (indirectionHandler != null) {
                    identity = indirectionHandler.getIdentity();
                } else {
                    clazz2 = object.getClass();
                    clazz = this.broker.getTopLevelClass(object.getClass());
                    if (classDescriptor == null) {
                        classDescriptor = this.broker.getClassDescriptor(object.getClass());
                    }
                    BrokerHelper brokerHelper = this.broker.serviceBrokerHelper();
                    FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
                    objectArray = new Object[fieldDescriptorArray.length];
                    for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                        FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                        Object object3 = fieldDescriptor.getPersistentField().get(object);
                        if (brokerHelper.representsNull(fieldDescriptor, object3)) {
                            identity = (Identity)this.objectToIdentityMap.get(object);
                            if (identity != null) break;
                            objectArray[i] = this.transientSequenceManager.getUniqueValue(fieldDescriptor);
                            identity = new Identity(clazz2, clazz, objectArray, true);
                            this.objectToIdentityMap.put(object, identity);
                            break;
                        }
                        objectArray[i] = object3;
                    }
                    if (identity == null) {
                        identity = new Identity(clazz2, clazz, objectArray, false);
                    }
                }
            }
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            throw classNotPersistenceCapableException;
        }
        catch (Exception exception) {
            throw this.createException(exception, "Can not init Identity for given object.", object, clazz, clazz2, objectArray);
        }
        return identity;
    }

    @Override
    public Identity buildIdentity(Object object) {
        return this.createTransientOrRealIdentity(this.broker.getClassDescriptor(ProxyHelper.getRealClass(object)), object);
    }

    @Override
    public Identity buildIdentity(ClassDescriptor classDescriptor, Object object) {
        return this.createTransientOrRealIdentity(classDescriptor, object);
    }

    @Override
    public Identity buildIdentity(Class clazz, Class clazz2, String[] stringArray, Object[] objectArray) {
        FieldDescriptor[] fieldDescriptorArray;
        Object[] objectArray2 = objectArray;
        if (objectArray == null) {
            throw new NullPointerException("Given primary key value array can't be null");
        }
        if ((objectArray.length != 1 || stringArray != null && stringArray.length != 1) && !this.isOrdered(fieldDescriptorArray = this.broker.getClassDescriptor(clazz).getPkFields(), stringArray)) {
            objectArray2 = this.reorderFieldValues(fieldDescriptorArray, stringArray, objectArray);
        }
        return new Identity(clazz, clazz2, objectArray2);
    }

    private Object[] reorderFieldValues(FieldDescriptor[] fieldDescriptorArray, String[] stringArray, Object[] objectArray) {
        Object[] objectArray2 = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            String string = fieldDescriptorArray[i].getPersistentField().getName();
            int n = this.findIndexForName(stringArray, string);
            objectArray2[i] = objectArray[n];
        }
        return objectArray2;
    }

    private int findIndexForName(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        throw new PersistenceBrokerException("Can't find field name '" + string + "' in given array of field names");
    }

    private boolean isOrdered(FieldDescriptor[] fieldDescriptorArray, String[] stringArray) {
        if (fieldDescriptorArray.length > 1 && stringArray == null || fieldDescriptorArray.length != stringArray.length) {
            throw new PersistenceBrokerException("pkFieldName length does not match number of defined PK fields. Expected number of PK fields is " + fieldDescriptorArray.length + ", given number was " + (stringArray != null ? stringArray.length : 0));
        }
        boolean bl = true;
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            bl = bl && fieldDescriptor.getPersistentField().getName().equals(stringArray[i]);
        }
        return bl;
    }

    @Override
    public Identity buildIdentity(Class clazz, String[] stringArray, Object[] objectArray) {
        return this.buildIdentity(clazz, this.broker.getTopLevelClass(clazz), stringArray, objectArray);
    }

    @Override
    public Identity buildIdentity(Class clazz, Class clazz2, Object[] objectArray) {
        return new Identity(clazz, clazz2, objectArray);
    }

    @Override
    public Identity buildIdentity(Class clazz, Object object) {
        return this.buildIdentity(clazz, (String[])null, new Object[]{object});
    }

    private PersistenceBrokerException createException(Exception exception, String string, Object object, Class clazz, Class clazz2, Object[] objectArray) {
        String string2 = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append("Unexpected error: ");
        } else {
            stringBuffer.append(string).append(" :");
        }
        if (clazz != null) {
            stringBuffer.append(string2).append("objectTopLevelClass=").append(clazz.getName());
        }
        if (clazz2 != null) {
            stringBuffer.append(string2).append("objectRealClass=").append(clazz2.getName());
        }
        if (objectArray != null) {
            stringBuffer.append(string2).append("pkValues=").append(ArrayUtils.toString((Object)objectArray));
        }
        if (object != null) {
            stringBuffer.append(string2).append("object to identify: ").append(object);
        }
        if (exception != null) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)exception);
            if (throwable != null) {
                stringBuffer.append(string2).append("The root stack trace is --> ");
                String string3 = ExceptionUtils.getStackTrace((Throwable)throwable);
                stringBuffer.append(string2).append(string3);
            }
            return new PersistenceBrokerException(stringBuffer.toString(), exception);
        }
        return new PersistenceBrokerException(stringBuffer.toString());
    }

    @Override
    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterCommit(PBStateEvent pBStateEvent) {
        if (this.objectToIdentityMap.size() > 0) {
            this.objectToIdentityMap.clear();
        }
    }

    @Override
    public void afterRollback(PBStateEvent pBStateEvent) {
        if (this.objectToIdentityMap.size() > 0) {
            this.objectToIdentityMap.clear();
        }
    }

    @Override
    public void beforeClose(PBStateEvent pBStateEvent) {
        if (this.objectToIdentityMap.size() > 0) {
            this.objectToIdentityMap.clear();
        }
    }

    @Override
    public void beforeRollback(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeCommit(PBStateEvent pBStateEvent) {
    }
}

