/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.util.spring;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.weaving.DefaultContextLoadTimeWeaver;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;

public class OptionalContextLoadTimeWeaver
implements LoadTimeWeaver,
BeanClassLoaderAware,
DisposableBean {
    private DefaultContextLoadTimeWeaver loadTimeWeaver = new DefaultContextLoadTimeWeaver();
    private boolean loadTimeWeaverLoaded;
    private ClassLoader beanClassLoader;

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        try {
            this.beanClassLoader = beanClassLoader;
            this.loadTimeWeaver.setBeanClassLoader(beanClassLoader);
            this.loadTimeWeaverLoaded = true;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        if (this.loadTimeWeaverLoaded) {
            this.loadTimeWeaver.addTransformer(transformer);
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        if (this.loadTimeWeaverLoaded) {
            return this.loadTimeWeaver.getInstrumentableClassLoader();
        }
        return this.beanClassLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        if (this.loadTimeWeaverLoaded) {
            return this.loadTimeWeaver.getThrowawayClassLoader();
        }
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }

    public void destroy() throws Exception {
        if (this.loadTimeWeaverLoaded) {
            this.loadTimeWeaver.destroy();
        }
    }
}

