/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExpressionDef;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.CommonXmlParser;
import org.kuali.rice.kew.xml.RuleExtensionXmlParser;
import org.xml.sax.SAXException;

public class RuleXmlParser {
    private static final Logger LOG = LogManager.getLogger(RuleXmlParser.class);
    private static final int DEFAULT_RULE_PRIORITY = 1;
    private static final boolean DEFAULT_FORCE_ACTION = false;
    private static final String DEFAULT_APPROVE_POLICY = ActionRequestPolicy.FIRST.getCode();
    private static final String DEFAULT_ACTION_REQUESTED = "A";

    public List<RuleDelegationBo> parseRuleDelegations(InputStream input) throws IOException, XmlException {
        try {
            Document doc = XmlHelper.trimSAXXml((InputStream)input);
            Element root = doc.getRootElement();
            return this.parseRuleDelegations(root);
        }
        catch (JDOMException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
    }

    public List<RuleBaseValues> parseRules(InputStream input) throws IOException, XmlException {
        try {
            Document doc = XmlHelper.trimSAXXml((InputStream)input);
            Element root = doc.getRootElement();
            return this.parseRules(root);
        }
        catch (JDOMException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
    }

    public List<RuleBaseValues> parseRules(Element element) throws XmlException {
        ArrayList<RuleBaseValues> rulesToSave = new ArrayList<RuleBaseValues>();
        for (Element rulesElement : element.getChildren("rules", XmlConstants.RULE_NAMESPACE)) {
            for (Element ruleElement : rulesElement.getChildren("rule", XmlConstants.RULE_NAMESPACE)) {
                RuleBaseValues rule = this.parseRule(ruleElement);
                rulesToSave.add(rule);
            }
        }
        this.checkForDuplicateRules(rulesToSave);
        return KEWServiceLocator.getRuleService().saveRules(rulesToSave, false);
    }

    public List<RuleDelegationBo> parseRuleDelegations(Element element) throws XmlException {
        ArrayList<RuleDelegationBo> ruleDelegationsToSave = new ArrayList<RuleDelegationBo>();
        for (Element ruleDelegationsElement : element.getChildren("ruleDelegations", XmlConstants.RULE_NAMESPACE)) {
            for (Element ruleDelegationElement : ruleDelegationsElement.getChildren("ruleDelegation", XmlConstants.RULE_NAMESPACE)) {
                RuleDelegationBo ruleDelegation = this.parseRuleDelegation(ruleDelegationElement);
                ruleDelegationsToSave.add(ruleDelegation);
            }
        }
        return KEWServiceLocator.getRuleService().saveRuleDelegations(ruleDelegationsToSave, false);
    }

    private void checkForDuplicateRules(List<RuleBaseValues> rules) throws XmlException {
        for (RuleBaseValues rule : rules) {
            if (!StringUtils.isBlank((String)rule.getName())) continue;
            LOG.debug("Checking for rule duplication on an anonymous rule.");
            this.checkRuleForDuplicate(rule);
        }
    }

    private void checkForDuplicateRuleDelegations(List<RuleDelegationBo> ruleDelegations) throws XmlException {
        for (RuleDelegationBo ruleDelegation : ruleDelegations) {
            if (!StringUtils.isBlank((String)ruleDelegation.getDelegationRule().getName())) continue;
            LOG.debug("Checking for rule duplication on an anonymous rule delegation.");
            this.checkRuleDelegationForDuplicate(ruleDelegation);
        }
    }

    private RuleDelegationBo parseRuleDelegation(Element element) throws XmlException {
        RuleDelegationBo ruleDelegation = new RuleDelegationBo();
        Element parentResponsibilityElement = element.getChild("parentResponsibility", element.getNamespace());
        if (parentResponsibilityElement == null) {
            throw new XmlException("parent responsibility was not defined");
        }
        String parentResponsibilityId = this.parseParentResponsibilityId(parentResponsibilityElement);
        String delegationType = element.getChildText("delegationType", element.getNamespace());
        if (delegationType == null || DelegationType.parseCode((String)delegationType) == null) {
            throw new XmlException("Invalid delegation type specified for delegate rule '" + delegationType + "'");
        }
        ruleDelegation.setResponsibilityId(parentResponsibilityId);
        ruleDelegation.setDelegationType(DelegationType.fromCode((String)delegationType));
        Element ruleElement = element.getChild("rule", element.getNamespace());
        RuleBaseValues rule = this.parseRule(ruleElement);
        rule.setDelegateRule(true);
        ruleDelegation.setDelegationRule(rule);
        return ruleDelegation;
    }

    private String parseParentResponsibilityId(Element element) throws XmlException {
        String responsibilityId = element.getChildText("responsibilityId", element.getNamespace());
        if (!StringUtils.isBlank((String)responsibilityId)) {
            return responsibilityId;
        }
        String parentRuleName = element.getChildText("parentRuleName", element.getNamespace());
        if (StringUtils.isBlank((String)parentRuleName)) {
            throw new XmlException("One of responsibilityId or parentRuleName needs to be defined");
        }
        RuleBaseValues parentRule = KEWServiceLocator.getRuleService().getRuleByName(parentRuleName);
        if (parentRule == null) {
            throw new XmlException("Could find the parent rule with name '" + parentRuleName + "'");
        }
        RuleResponsibilityBo ruleResponsibilityNameAndType = CommonXmlParser.parseResponsibilityNameAndType(element);
        if (ruleResponsibilityNameAndType == null) {
            throw new XmlException("Could not locate a valid responsibility declaration for the parent responsibility.");
        }
        String parentResponsibilityId = KEWServiceLocator.getRuleService().findResponsibilityIdForRule(parentRuleName, ruleResponsibilityNameAndType.getRuleResponsibilityName(), ruleResponsibilityNameAndType.getRuleResponsibilityType());
        if (parentResponsibilityId == null) {
            throw new XmlException("Failed to locate parent responsibility for rule with name '" + parentRuleName + "' and responsibility " + ruleResponsibilityNameAndType);
        }
        return parentResponsibilityId;
    }

    private RuleBaseValues parseRule(Element element) throws XmlException {
        String name = element.getChildText("name", element.getNamespace());
        RuleBaseValues rule = this.createRule(name);
        this.setDefaultRuleValues(rule);
        rule.setName(name);
        String toDatestr = element.getChildText("toDate", element.getNamespace());
        String fromDatestr = element.getChildText("fromDate", element.getNamespace());
        rule.setToDateValue(this.formatDate("toDate", toDatestr));
        rule.setFromDateValue(this.formatDate("fromDate", fromDatestr));
        String description = element.getChildText("description", element.getNamespace());
        if (StringUtils.isBlank((String)description)) {
            throw new XmlException("Rule must have a description.");
        }
        String documentTypeName = element.getChildText("documentType", element.getNamespace());
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new XmlException("Rule must have a document type.");
        }
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        if (documentType == null) {
            throw new XmlException("Could not locate document type '" + documentTypeName + "'");
        }
        RuleTemplateBo ruleTemplate = null;
        String ruleTemplateName = element.getChildText("ruleTemplate", element.getNamespace());
        Element ruleExtensionsElement = element.getChild("ruleExtensions", element.getNamespace());
        if (!StringUtils.isBlank((String)ruleTemplateName)) {
            ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(ruleTemplateName);
            if (ruleTemplate == null) {
                throw new XmlException("Could not locate rule template '" + ruleTemplateName + "'");
            }
        } else if (ruleExtensionsElement != null) {
            throw new XmlException("Templateless rules may not have rule extensions");
        }
        RuleExpressionDef ruleExpressionDef = null;
        Element exprElement = element.getChild("expression", element.getNamespace());
        if (exprElement != null) {
            String exprType = exprElement.getAttributeValue("type");
            if (StringUtils.isEmpty((String)exprType)) {
                throw new XmlException("Expression type must be specified");
            }
            String expression = exprElement.getTextTrim();
            ruleExpressionDef = new RuleExpressionDef();
            ruleExpressionDef.setType(exprType);
            ruleExpressionDef.setExpression(expression);
        }
        String forceActionValue = element.getChildText("forceAction", element.getNamespace());
        Boolean forceAction = false;
        if (!StringUtils.isBlank((String)forceActionValue)) {
            forceAction = Boolean.valueOf(forceActionValue);
        }
        rule.setDocTypeName(documentType.getName());
        if (ruleTemplate != null) {
            rule.setRuleTemplateId(ruleTemplate.getId());
            rule.setRuleTemplate(ruleTemplate);
        }
        if (ruleExpressionDef != null) {
            rule.setRuleExpressionDef(ruleExpressionDef);
        }
        rule.setDescription(description);
        rule.setForceAction(forceAction);
        Element responsibilitiesElement = element.getChild("responsibilities", element.getNamespace());
        rule.setRuleResponsibilities(this.parseResponsibilities(responsibilitiesElement, rule));
        rule.setRuleExtensions(this.parseRuleExtensions(ruleExtensionsElement, rule));
        return rule;
    }

    private RuleBaseValues createRule(String ruleName) {
        RuleBaseValues existingRule;
        RuleBaseValues rule = new RuleBaseValues();
        RuleBaseValues ruleBaseValues = existingRule = ruleName != null ? KEWServiceLocator.getRuleService().getRuleByName(ruleName) : null;
        if (existingRule != null) {
            rule.setId(existingRule.getId());
            rule.setPreviousRuleId(existingRule.getPreviousRuleId());
            rule.setPreviousVersion(existingRule.getPreviousVersion());
            rule.setRuleResponsibilities(existingRule.getRuleResponsibilities());
        }
        return rule;
    }

    private void checkRuleForDuplicate(RuleBaseValues rule) throws XmlException {
        String ruleId = KEWServiceLocator.getRuleService().getDuplicateRuleId(rule);
        if (ruleId != null) {
            throw new XmlException("Rule '" + rule.getDescription() + "' on doc '" + rule.getDocTypeName() + "' is a duplicate of rule with rule Id " + ruleId);
        }
    }

    private void checkRuleDelegationForDuplicate(RuleDelegationBo ruleDelegation) throws XmlException {
        this.checkRuleForDuplicate(ruleDelegation.getDelegationRule());
    }

    private void setDefaultRuleValues(RuleBaseValues rule) throws XmlException {
        rule.setForceAction(Boolean.FALSE);
        rule.setActivationDate(new Timestamp(System.currentTimeMillis()));
        rule.setActive(Boolean.TRUE);
        rule.setCurrentInd(Boolean.TRUE);
        rule.setTemplateRuleInd(Boolean.FALSE);
        rule.setVersionNbr(new Integer(0));
        rule.setDelegateRule(false);
    }

    private List<RuleResponsibilityBo> parseResponsibilities(Element element, RuleBaseValues rule) throws XmlException {
        if (element == null) {
            return new ArrayList<RuleResponsibilityBo>(0);
        }
        List<RuleResponsibilityBo> existingResponsibilities = rule.getRuleResponsibilities();
        ArrayList<RuleResponsibilityBo> responsibilities = new ArrayList<RuleResponsibilityBo>();
        List responsibilityElements = element.getChildren("responsibility", element.getNamespace());
        for (Element responsibilityElement : responsibilityElements) {
            RuleResponsibilityBo responsibility = this.parseResponsibility(responsibilityElement, rule);
            this.reconcileWithExistingResponsibility(responsibility, existingResponsibilities);
            responsibilities.add(responsibility);
        }
        if (responsibilities.size() == 0) {
            throw new XmlException("Rule responsibility list must have at least one responsibility.");
        }
        return responsibilities;
    }

    public RuleResponsibilityBo parseResponsibility(Element element, RuleBaseValues rule) throws XmlException {
        RuleResponsibilityBo responsibility = new RuleResponsibilityBo();
        responsibility.setRuleBaseValues(rule);
        String actionRequested = null;
        String priority = null;
        actionRequested = element.getChildText("actionRequested", element.getNamespace());
        if (StringUtils.isBlank((String)actionRequested)) {
            actionRequested = DEFAULT_ACTION_REQUESTED;
        }
        if (StringUtils.isBlank((String)(priority = element.getChildText("priority", element.getNamespace())))) {
            priority = String.valueOf(1);
        }
        String approvePolicy = element.getChildText("approvePolicy", element.getNamespace());
        Element delegations = element.getChild("delegations", element.getNamespace());
        if (actionRequested == null) {
            throw new XmlException("actionRequested is required on responsibility");
        }
        if (!(actionRequested.equals("C") || actionRequested.equals(DEFAULT_ACTION_REQUESTED) || actionRequested.equals("K") || actionRequested.equals("F"))) {
            throw new XmlException("Invalid action requested code '" + actionRequested + "'");
        }
        if (StringUtils.isBlank((String)approvePolicy)) {
            approvePolicy = DEFAULT_APPROVE_POLICY;
        }
        if (!approvePolicy.equals(ActionRequestPolicy.ALL.getCode()) && !approvePolicy.equals(ActionRequestPolicy.FIRST.getCode())) {
            throw new XmlException("Invalid approve policy '" + approvePolicy + "'");
        }
        Integer priorityNumber = Integer.valueOf(priority);
        responsibility.setActionRequestedCd(actionRequested);
        responsibility.setPriority(priorityNumber);
        responsibility.setApprovePolicy(approvePolicy);
        RuleResponsibilityBo responsibilityNameAndType = CommonXmlParser.parseResponsibilityNameAndType(element);
        if (responsibilityNameAndType == null) {
            throw new XmlException("Could not locate a valid responsibility declaration on a responsibility on rule with description '" + rule.getDescription() + "'");
        }
        if (responsibilityNameAndType.getRuleResponsibilityType().equals("G") && responsibility.getApprovePolicy().equals(ActionRequestPolicy.ALL.getCode())) {
            throw new XmlException("Invalid approve policy '" + approvePolicy + "'.  This policy is not supported with Groups.");
        }
        responsibility.setRuleResponsibilityName(responsibilityNameAndType.getRuleResponsibilityName());
        responsibility.setRuleResponsibilityType(responsibilityNameAndType.getRuleResponsibilityType());
        return responsibility;
    }

    private void reconcileWithExistingResponsibility(RuleResponsibilityBo responsibility, List<RuleResponsibilityBo> existingResponsibilities) {
        if (existingResponsibilities == null || existingResponsibilities.isEmpty()) {
            return;
        }
        RuleResponsibilityBo exactMatch = null;
        for (RuleResponsibilityBo existingResponsibility : existingResponsibilities) {
            if (!this.isExactResponsibilityMatch(responsibility, existingResponsibility)) continue;
            exactMatch = existingResponsibility;
            break;
        }
        if (exactMatch != null) {
            responsibility.setResponsibilityId(exactMatch.getResponsibilityId());
        }
    }

    private boolean isExactResponsibilityMatch(RuleResponsibilityBo newResponsibility, RuleResponsibilityBo existingResponsibility) {
        if (existingResponsibility.getResponsibilityId().equals(newResponsibility.getResponsibilityId())) {
            return true;
        }
        return existingResponsibility.getRuleResponsibilityName().equals(newResponsibility.getRuleResponsibilityName()) && existingResponsibility.getRuleResponsibilityType().equals(newResponsibility.getRuleResponsibilityType()) && existingResponsibility.getApprovePolicy().equals(newResponsibility.getApprovePolicy()) && existingResponsibility.getActionRequestedCd().equals(newResponsibility.getActionRequestedCd()) && existingResponsibility.getPriority().equals(newResponsibility.getPriority());
    }

    private List parseRuleExtensions(Element element, RuleBaseValues rule) throws XmlException {
        if (element == null) {
            return new ArrayList();
        }
        RuleExtensionXmlParser parser = new RuleExtensionXmlParser();
        return parser.parseRuleExtensions(element, rule);
    }

    public Timestamp formatDate(String dateLabel, String dateString) throws XmlException {
        if (StringUtils.isBlank((String)dateString)) {
            return null;
        }
        try {
            return new Timestamp(RiceConstants.getDefaultDateFormat().parse(dateString).getTime());
        }
        catch (ParseException e) {
            throw new XmlException(dateLabel + " is not in the proper format.  Should have been: hh:mm a MM/dd/yyyy", (Throwable)e);
        }
    }
}

