/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;

public class NamedRootsMap {
    private Logger log = LoggerFactory.getLogger(NamedRootsMap.class);
    private TransactionImpl tx;
    private HashMap tempBindings;
    private Map deletionMap;
    private Map insertMap;

    NamedRootsMap(TransactionImpl transactionImpl) {
        this.tx = transactionImpl;
        this.tempBindings = new HashMap();
    }

    private void addForDeletion(NamedEntry namedEntry) {
        if (this.deletionMap == null) {
            this.deletionMap = new HashMap();
        }
        this.deletionMap.put(namedEntry.getName(), namedEntry);
    }

    private void addForInsert(NamedEntry namedEntry) {
        if (this.insertMap == null) {
            this.insertMap = new HashMap();
        }
        this.insertMap.put(namedEntry.getName(), namedEntry);
        if (this.deletionMap != null) {
            this.deletionMap.remove(namedEntry.getName());
        }
    }

    public void performDeletion() {
        if (this.deletionMap == null) {
            return;
        }
        PersistenceBroker persistenceBroker = this.tx.getBroker();
        for (NamedEntry namedEntry : this.deletionMap.values()) {
            persistenceBroker.delete(namedEntry);
        }
    }

    public void performInsert() {
        if (this.insertMap == null) {
            return;
        }
        PersistenceBroker persistenceBroker = this.tx.getBroker();
        for (NamedEntry namedEntry : this.insertMap.values()) {
            namedEntry.prepareForStore(persistenceBroker);
            persistenceBroker.store(namedEntry, ObjectModification.INSERT);
        }
    }

    public void afterWriteCleanup() {
        if (this.deletionMap != null) {
            this.deletionMap.clear();
        }
        if (this.insertMap != null) {
            this.insertMap.clear();
        }
    }

    private void localBind(String string, NamedEntry namedEntry) throws ObjectNameNotUniqueException {
        if (this.tempBindings.containsKey(string)) {
            throw new ObjectNameNotUniqueException("Object key already in use, the key '" + string + "' is not unique");
        }
        this.tempBindings.put(string, namedEntry);
    }

    private void localUnbind(String string) {
        this.tempBindings.remove(string);
    }

    private NamedEntry localLookup(String string) {
        return (NamedEntry)this.tempBindings.get(string);
    }

    Object lookup(String string) throws ObjectNameNotFoundException {
        Identity identity;
        Object object;
        Object object2 = null;
        NamedEntry namedEntry = this.localLookup(string);
        if (namedEntry == null) {
            try {
                object = this.tx.getBroker();
                identity = object.serviceIdentity().buildIdentity(NamedEntry.class, (Object)string);
                namedEntry = (NamedEntry)object.getObjectByIdentity(identity);
            }
            catch (Exception exception) {
                this.log.error("Can't materialize bound object for key '" + string + "'", exception);
            }
        }
        if (namedEntry == null) {
            this.log.info("No object found for key '" + string + "'");
        } else {
            object = namedEntry.getObject();
            if (object instanceof Identity) {
                identity = (Identity)object;
                object2 = this.tx.getBroker().getObjectByIdentity(identity);
                RuntimeObject runtimeObject = new RuntimeObject(object2, identity, this.tx, false);
                this.tx.lockAndRegister(runtimeObject, 1, this.tx.getRegistrationList());
            } else {
                object2 = object;
            }
        }
        if (object2 == null) {
            throw new ObjectNameNotFoundException("Can't find named object for name '" + string + "'");
        }
        return object2;
    }

    void unbind(String string) {
        NamedEntry namedEntry = new NamedEntry(string, null, false);
        this.localUnbind(string);
        this.addForDeletion(namedEntry);
    }

    public void bind(Object object, String string) throws ObjectNameNotUniqueException {
        Serializable serializable;
        Object object2;
        boolean bl = true;
        PersistenceBroker persistenceBroker = this.tx.getBroker();
        ClassDescriptor classDescriptor = null;
        try {
            classDescriptor = persistenceBroker.getClassDescriptor(ProxyHelper.getRealClass(object));
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        if (classDescriptor == null) {
            bl = false;
            if (!(object instanceof Serializable)) {
                throw new ClassNotPersistenceCapableException("Can't bind named object, because it's not Serializable. Name=" + string + ", object=" + object);
            }
        } else {
            object2 = new RuntimeObject(object, this.tx);
            if (!((RuntimeObject)object2).isNew()) {
                this.tx.lockAndRegister((RuntimeObject)object2, 1, this.tx.getRegistrationList());
            } else {
                this.tx.makePersistent((RuntimeObject)object2);
            }
        }
        if ((object2 = this.localLookup(string)) == null) {
            serializable = persistenceBroker.serviceIdentity().buildIdentity(NamedEntry.class, (Object)string);
            object2 = (NamedEntry)persistenceBroker.getObjectByIdentity((Identity)serializable);
        }
        if (object2 != null) {
            throw new ObjectNameNotUniqueException("The name of the specified named object already exist, name=" + string);
        }
        serializable = new NamedEntry(string, object, bl);
        this.addForInsert((NamedEntry)serializable);
        this.localBind(string, (NamedEntry)serializable);
    }

    public static final class NamedEntry
    implements Serializable {
        static final long serialVersionUID = 6179717896336300342L;
        private String name;
        private byte[] oid;
        private transient Object object;
        private transient boolean useIdentity;

        public NamedEntry() {
        }

        NamedEntry(String string, Object object, boolean bl) {
            this.name = string;
            this.object = object;
            this.useIdentity = bl;
        }

        public void prepareForStore(PersistenceBroker persistenceBroker) {
            if (this.object != null) {
                if (this.useIdentity) {
                    Identity identity = persistenceBroker.serviceIdentity().buildIdentity(this.object);
                    this.oid = SerializationUtils.serialize((Serializable)identity);
                } else {
                    this.oid = SerializationUtils.serialize((Serializable)((Serializable)this.object));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public byte[] getOid() {
            return this.oid;
        }

        public void setOid(byte[] byArray) {
            this.oid = byArray;
        }

        Object getObject() {
            if (this.object != null) {
                return this.object;
            }
            return this.oid != null ? SerializationUtils.deserialize((byte[])this.oid) : null;
        }
    }
}

