/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.TypedStringValue;

public class ViewModelUtils {
    public static Class<?> getPropertyTypeByClassAndView(View view, Object model, String propertyPath) {
        if (StringUtils.isBlank((String)propertyPath)) {
            return null;
        }
        Class<?> propertyType = null;
        Class<?> modelClass = null;
        String modelProperty = propertyPath;
        int bestMatchLength = 0;
        String flattenedPropertyPath = propertyPath.replaceAll("\\[.+\\]", "");
        Map<String, Class<?>> modelClasses = view.getObjectPathToConcreteClassMapping();
        for (String path : modelClasses.keySet()) {
            if (StringUtils.equals((String)path, (String)flattenedPropertyPath)) {
                propertyType = modelClasses.get(path);
                break;
            }
            if (!flattenedPropertyPath.startsWith(path) || path.length() <= bestMatchLength) continue;
            bestMatchLength = path.length();
            modelClass = modelClasses.get(path);
            modelProperty = StringUtils.removeStart((String)flattenedPropertyPath, (String)path);
            modelProperty = StringUtils.removeStart((String)modelProperty, (String)".");
        }
        if (propertyType == null) {
            propertyType = modelClass == null ? ObjectPropertyUtils.getPropertyType(model, propertyPath) : ObjectPropertyUtils.getPropertyType(modelClass, modelProperty);
        }
        return propertyType;
    }

    public static String getParentObjectPath(DataField field) {
        String propertyPrefix;
        StringBuilder parentObjectPath = new StringBuilder();
        BindingInfo fieldBindingInfo = field.getBindingInfo();
        String objectPath = fieldBindingInfo.getBindingObjectPath();
        if (!fieldBindingInfo.isBindToForm() && StringUtils.isNotBlank((String)objectPath)) {
            parentObjectPath.append(objectPath);
        }
        if (StringUtils.isNotBlank((String)(propertyPrefix = fieldBindingInfo.getBindByNamePrefix()))) {
            if (parentObjectPath.length() > 0) {
                parentObjectPath.append('.');
            }
            parentObjectPath.append(propertyPrefix);
        }
        return parentObjectPath.toString();
    }

    public static Class<?> getParentObjectClassForMetadata(View view, Object model, DataField field) {
        String parentObjectPath = ViewModelUtils.getParentObjectPath(field);
        return ViewModelUtils.getObjectClassForMetadata(view, model, parentObjectPath);
    }

    public static Class<?> getObjectClassForMetadata(View view, Object model, String propertyPath) {
        Object parentObject = ObjectPropertyUtils.getPropertyValue(model, propertyPath);
        if (parentObject != null) {
            return parentObject.getClass();
        }
        return ViewModelUtils.getPropertyTypeByClassAndView(view, model, propertyPath);
    }

    public static Object getParentObjectForMetadata(View view, Object model, DataField field) {
        Object parentObject = model;
        String parentObjectPath = ViewModelUtils.getParentObjectPath(field);
        if (StringUtils.isNotBlank((String)parentObjectPath) && ((parentObject = ObjectPropertyUtils.getPropertyValue(model, parentObjectPath)) == null || Collection.class.isAssignableFrom(parentObject.getClass()) || Map.class.isAssignableFrom(parentObject.getClass()))) {
            try {
                Class<?> parentObjectClass = ViewModelUtils.getPropertyTypeByClassAndView(view, model, parentObjectPath);
                if (parentObjectClass != null) {
                    parentObject = parentObjectClass.newInstance();
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return parentObject;
    }

    public static String getStringValFromPVs(PropertyValues propertyValues, String propertyName) {
        String propertyValue = null;
        if (propertyValues != null && propertyValues.contains(propertyName)) {
            Object pvValue = propertyValues.getPropertyValue(propertyName).getValue();
            if (pvValue instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)pvValue;
                propertyValue = typedStringValue.getValue();
            } else if (pvValue instanceof String) {
                propertyValue = (String)pvValue;
            }
        }
        return propertyValue;
    }
}

