/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.converters;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;

@Converter
public class EncryptionConverter
implements AttributeConverter<String, String> {
    public String convertToDatabaseColumn(String objectValue) {
        if (objectValue == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)objectValue.toString())) {
            return "";
        }
        try {
            if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                return CoreApiServiceLocator.getEncryptionService().encrypt((Object)objectValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while attempting to encrypt value for DB: ", e);
        }
        return objectValue;
    }

    public String convertToEntityAttribute(String dataValue) {
        if (dataValue == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)dataValue.toString())) {
            return "";
        }
        try {
            if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                return CoreApiServiceLocator.getEncryptionService().decrypt(dataValue.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while attempting to decrypt value from DB: ", e);
        }
        return dataValue;
    }
}

