/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.location;

import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentOrganizationController
extends ProposalDevelopmentControllerBase {
    private static final String ALLOW_APPLICANT_ORGANIZATION_CHANGE_PARAM = "Allow_Applicant_Organization_Change";
    private static final String ORGANIZATION_PROPERTY = "organization";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refresh", "refreshCaller=Organization-LookupView"})
    public ModelAndView refreshOrganization(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.initializeProposalSite(form.getDevelopmentProposal().getPerformingOrganization());
        if (this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, ALLOW_APPLICANT_ORGANIZATION_CHANGE_PARAM, Boolean.valueOf(false)).booleanValue()) {
            this.initializeProposalSite(form.getDevelopmentProposal().getApplicantOrganization());
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    protected void initializeProposalSite(ProposalSite site) {
        this.getDataObjectService().wrap((Object)site).fetchRelationship(ORGANIZATION_PROPERTY);
        site.initializeDefaultCongressionalDistrict();
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }
}

