/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormAttContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormAttFileContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.propdev.api.s2s.UserAttachedFormService;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormAttFile;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormFile;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="userAttachedFormService")
public class UserAttachedFormServiceImpl
implements UserAttachedFormService {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public S2sUserAttachedFormContract findFormByProposalNumberAndNamespace(String proposalNumber, String namespace) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("proposalNumber", proposalNumber);
        fieldMap.put("namespace", namespace);
        List userAttachedForms = this.dataObjectService.findMatching(S2sUserAttachedForm.class, QueryByCriteria.Builder.andAttributes(fieldMap).build()).getResults();
        return userAttachedForms.isEmpty() ? null : (S2sUserAttachedFormContract)userAttachedForms.iterator().next();
    }

    public String findFormNameByProposalNumberAndNamespace(String proposalNumber, String namespace) {
        S2sUserAttachedFormContract form = this.findFormByProposalNumberAndNamespace(proposalNumber, namespace);
        return form != null ? form.getNamespace() : null;
    }

    public List<String> findFormNamespaces(String proposalNumber) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        List<S2sUserAttachedForm> forms = this.findUserAttachedFormByProposalNumber(proposalNumber);
        ArrayList<String> namespaces = new ArrayList<String>();
        for (S2sUserAttachedForm form : forms) {
            namespaces.add(form.getNamespace());
        }
        return namespaces;
    }

    protected List<S2sUserAttachedForm> findUserAttachedFormByProposalNumber(String proposalNumber) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("proposalNumber", proposalNumber);
        return ListUtils.emptyIfNull((List)this.dataObjectService.findMatching(S2sUserAttachedForm.class, QueryByCriteria.Builder.andAttributes(fieldMap).build()).getResults());
    }

    public S2sUserAttachedFormFileContract findUserAttachedFormFile(S2sUserAttachedFormContract selectedForm) {
        if (selectedForm == null) {
            throw new IllegalArgumentException("selectedForm is null");
        }
        List selectedFormFiles = selectedForm.getS2sUserAttachedFormFileList();
        S2sUserAttachedFormFileContract userAttachedFormFile = null;
        if (selectedFormFiles.isEmpty() || ((S2sUserAttachedFormFileContract)selectedFormFiles.get(0)).getXmlFile() == null) {
            selectedFormFiles = this.getDataObjectService().findMatching(S2sUserAttachedFormFile.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("s2sUserAttachedFormId", selectedForm.getId())).build()).getResults();
            if (!selectedFormFiles.isEmpty()) {
                userAttachedFormFile = (S2sUserAttachedFormFileContract)selectedFormFiles.get(0);
            }
        } else {
            userAttachedFormFile = (S2sUserAttachedFormFileContract)selectedFormFiles.get(0);
        }
        return userAttachedFormFile;
    }

    public S2sUserAttachedFormAttFileContract findUserAttachedFormAttFile(S2sUserAttachedFormAttContract selectedFormAtt) {
        if (selectedFormAtt == null) {
            throw new IllegalArgumentException("selectedFormAtt is null");
        }
        List selectedFormAttFiles = selectedFormAtt.getS2sUserAttachedFormAttFiles();
        S2sUserAttachedFormAttFileContract userAttachedFormFile = null;
        if (selectedFormAttFiles.isEmpty()) {
            selectedFormAttFiles = this.getDataObjectService().findMatching(S2sUserAttachedFormAttFile.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("s2sUserAttachedFormAttId", selectedFormAtt.getId())).build()).getResults();
            if (!selectedFormAttFiles.isEmpty()) {
                userAttachedFormFile = (S2sUserAttachedFormAttFileContract)selectedFormAttFiles.get(0);
            }
        } else {
            userAttachedFormFile = (S2sUserAttachedFormAttFileContract)selectedFormAttFiles.get(0);
        }
        return userAttachedFormFile;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

