/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.HasBroker;
import org.odmg.Transaction;

public final class PBCapsule {
    private static Logger log = LoggerFactory.getLogger(PBCapsule.class);
    PersistenceBroker broker;
    PBKey pbKey;
    Transaction tx;
    boolean needsTxCommit = false;
    boolean needsPBCommit = false;
    boolean isIlleagal = false;

    public PBCapsule(PBKey pBKey, Transaction transaction) {
        this.tx = transaction;
        this.pbKey = pBKey;
        this.prepare();
    }

    public PersistenceBroker getBroker() {
        if (this.isIlleagal) {
            throw new OJBRuntimeException("You could not reuse PBCapsule after destroy");
        }
        return this.broker;
    }

    private void prepare() {
        if (this.isIlleagal) {
            throw new OJBRuntimeException("You could not reuse PBCapsule after destroy");
        }
        if (this.tx == null) {
            if (log.isDebugEnabled()) {
                log.debug("No running transaction found, try to get PersistenceBroker instance via PBKey " + this.pbKey);
            }
            this.broker = this.obtainBroker();
            if (!this.broker.isInTransaction()) {
                this.broker.beginTransaction();
                this.needsPBCommit = true;
            }
        } else {
            if (!this.tx.isOpen()) {
                this.tx.begin();
                this.needsTxCommit = true;
            }
            this.broker = ((HasBroker)((Object)this.tx)).getBroker();
        }
    }

    public void destroy() {
        if (this.needsTxCommit) {
            if (log.isDebugEnabled()) {
                log.debug("Indicated to commit tx");
            }
            this.tx.commit();
        } else if (this.needsPBCommit) {
            if (log.isDebugEnabled()) {
                log.debug("Indicated to commit PersistenceBroker");
            }
            try {
                this.broker.commitTransaction();
            }
            finally {
                if (this.broker != null) {
                    this.broker.close();
                }
            }
        }
        this.isIlleagal = true;
        this.needsTxCommit = false;
        this.needsPBCommit = false;
    }

    private PersistenceBroker obtainBroker() {
        PersistenceBroker persistenceBroker;
        try {
            if (this.pbKey == null) {
                log.warn("No tx runnning and PBKey is null, try to use the default PB");
                persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
            } else {
                persistenceBroker = PersistenceBrokerFactory.createPersistenceBroker(this.pbKey);
            }
        }
        catch (PBFactoryException pBFactoryException) {
            log.error("Could not obtain PB for PBKey " + this.pbKey, (Throwable)((Object)pBFactoryException));
            throw new OJBRuntimeException("Unexpected micro-kernel exception", (Throwable)((Object)pBFactoryException));
        }
        return persistenceBroker;
    }
}

