/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.hierarchy;

import java.util.List;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.budget.hierarchy.ProposalBudgetHierarchyService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyErrorWarningDto;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalBudgetHierarchyController
extends ProposalBudgetControllerBase {
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="proposalBudgetHierarchyService")
    private ProposalBudgetHierarchyService proposalBudgetHierarchyService;

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=syncAllBudgets"})
    public ModelAndView syncAllBudgets(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        DevelopmentProposal hierarchyProposal = form.getDevelopmentProposal();
        List<ProposalHierarchyErrorWarningDto> errors = this.getProposalHierarchyService().validateParent(hierarchyProposal);
        if (!this.displayErrors(errors)) {
            this.getProposalBudgetHierarchyService().synchronizeAllChildBudgets(hierarchyProposal);
            this.displayMessage("message.hierarchy.sync.success", new String[0]);
            ((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).prepareHierarchySummary(form);
        }
        this.saveBudget(form);
        this.checkAudit(form);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=syncBudget"})
    public ModelAndView syncBudget(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        DevelopmentProposal childProposal = form.getDevelopmentProposal();
        DevelopmentProposal hierarchy = this.getProposalHierarchyService().getDevelopmentProposal(childProposal.getHierarchyParentProposalNumber());
        List<ProposalHierarchyErrorWarningDto> errors = this.getProposalHierarchyService().validateChildForSync(childProposal, hierarchy, false);
        if (!this.displayErrors(errors)) {
            this.getProposalBudgetHierarchyService().synchronizeChildBudget(hierarchy, form.getBudget());
            this.getProposalBudgetHierarchyService().persistProposalHierarchyBudget(hierarchy);
            this.displayMessage("message.hierarchy.sync.success", new String[0]);
            ((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).prepareHierarchySummary(form);
        }
        this.saveBudget(form);
        this.checkAudit(form);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropBudget-HierarchySummaryPage"})
    public ModelAndView navigateToSubmit(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).prepareHierarchySummary(form);
        return super.navigate(form);
    }

    protected void displayMessage(String messageKey, String ... errorParameters) {
        this.getGlobalVariableService().getMessageMap().putInfo("newHierarchyProposal.x", messageKey, errorParameters);
    }

    protected boolean displayErrors(List<ProposalHierarchyErrorWarningDto> errors) {
        int severeErrors = 0;
        for (ProposalHierarchyErrorWarningDto error : errors) {
            severeErrors += error.isSevere() ? 1 : 0;
            if (error.isSevere()) {
                this.getGlobalVariableService().getMessageMap().putError("newHierarchyProposal.x", error.getErrorKey(), error.getErrorParameters());
                continue;
            }
            this.getGlobalVariableService().getMessageMap().putWarning("newHierarchyProposal.x", error.getErrorKey(), error.getErrorParameters());
        }
        return severeErrors > 0;
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public ProposalBudgetHierarchyService getProposalBudgetHierarchyService() {
        return this.proposalBudgetHierarchyService;
    }

    public void setProposalBudgetHierarchyService(ProposalBudgetHierarchyService proposalBudgetHierarchyService) {
        this.proposalBudgetHierarchyService = proposalBudgetHierarchyService;
    }
}

