/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.docperm;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.person.PersonTypeConstants;
import org.kuali.coeus.common.view.wizard.framework.WizardControllerService;
import org.kuali.coeus.common.view.wizard.framework.WizardResultsDto;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentPermissionsController
extends ProposalDevelopmentControllerBase {
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="wizardControllerService")
    private WizardControllerService wizardControllerService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=savePermission"})
    public ModelAndView savePermission(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        boolean success = this.getProposalDevelopmentPermissionsService().validateUpdatePermissions(form.getProposalDevelopmentDocument(), form.getWorkingUserRoles(), form.getWorkingUserRoles().get(Integer.parseInt(selectedLine)));
        if (success) {
            this.getProposalDevelopmentPermissionsService().processUpdatePermission(form.getProposalDevelopmentDocument(), form.getWorkingUserRoles().get(Integer.parseInt(selectedLine)));
            if (form.getEditableCollectionLines().containsKey(selectedCollectionPath)) {
                form.getEditableCollectionLines().get(selectedCollectionPath).remove(selectedLine);
            }
            form.setEvaluateFlagsAndModes(true);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=performPermissionSearch"})
    public ModelAndView performPermissionSearch(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.getAddKeyPersonHelper().getResults().clear();
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object object : this.getWizardControllerService().performWizardSearch(form.getAddKeyPersonHelper().getLookupFieldValues(), form.getAddKeyPersonHelper().getLineType())) {
            WizardResultsDto wizardResult = (WizardResultsDto)object;
            String userName = wizardResult.getKcPerson().getUserName();
            if (this.userAlreadyExists(userName, form.getWorkingUserRoles())) continue;
            results.add(object);
        }
        form.getAddKeyPersonHelper().setResults(results);
        form.getAddKeyPersonHelper().getLookupFieldValues().clear();
        form.getAddKeyPersonHelper().getParameterMap().clear();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    protected boolean userAlreadyExists(String userName, List<ProposalUserRoles> existingUsers) {
        for (ProposalUserRoles existingUser : existingUsers) {
            if (!userName.equals(existingUser.getUsername())) continue;
            return true;
        }
        return false;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addPermission"})
    public ModelAndView addPermission(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        Object roleNames;
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        ProposalUserRoles newProposalUserRoles = new ProposalUserRoles();
        for (Object object : form.getAddKeyPersonHelper().getResults()) {
            WizardResultsDto wizardResult = (WizardResultsDto)object;
            if (!wizardResult.isSelected()) continue;
            if (wizardResult.getKcPerson() == null) break;
            newProposalUserRoles.setFullname(wizardResult.getKcPerson().getFullName());
            newProposalUserRoles.setUsername(wizardResult.getKcPerson().getUserName());
            break;
        }
        if ((roleNames = form.getAddKeyPersonHelper().getParameter("roleNames")) instanceof String) {
            newProposalUserRoles.getRoleNames().add((String)roleNames);
        } else if (roleNames instanceof String[]) {
            for (String roleName : (String[])roleNames) {
                newProposalUserRoles.getRoleNames().add(roleName);
            }
        }
        if (this.getProposalDevelopmentPermissionsService().validateAddPermissions(document, form.getWorkingUserRoles(), newProposalUserRoles)) {
            this.getProposalDevelopmentPermissionsService().processAddPermission(document, newProposalUserRoles);
            form.getWorkingUserRoles().add(newProposalUserRoles);
            if (form.getWorkflowDocument().isEnroute()) {
                return super.save(form);
            }
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareAddPermission"})
    public ModelAndView prepareAddPermission(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.getAddKeyPersonHelper().setLineType(PersonTypeConstants.EMPLOYEE.getCode());
        return this.getModelAndViewService().showDialog("PropDev-PermissionsPage-Wizard", true, (UifFormBase)form);
    }

    public WizardControllerService getWizardControllerService() {
        return this.wizardControllerService;
    }

    public void setWizardControllerService(WizardControllerService wizardControllerService) {
        this.wizardControllerService = wizardControllerService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }
}

