/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.common.impl.krms.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalJavaFunctionKrmsTermService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;

public class InstitutionalProposalJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements InstitutionalProposalJavaFunctionKrmsTermService {
    private FiscalYearMonthService fiscalYearMonthService;

    @Override
    public Boolean isCurrentFiscalMonth(InstitutionalProposal ip) {
        String currentFiscalYear = this.getFiscalYearMonthService().getCurrentFiscalYear().toString();
        String currentFiscalMonth = StringUtils.leftPad((String)this.getFiscalYearMonthService().getCurrentFiscalMonth().toString(), (int)2, (char)'0');
        return Objects.equals(currentFiscalMonth, ip.getFiscalMonth()) && Objects.equals(currentFiscalYear, ip.getFiscalYear());
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }

    @Override
    public Boolean hasSpecialReviewOfType(InstitutionalProposal ip, String specialReviewType) {
        return ip.getSpecialReviews().stream().anyMatch(ipReview -> this.doesSpecialReviewMatch((InstitutionalProposalSpecialReview)ipReview, specialReviewType));
    }

    public boolean doesSpecialReviewMatch(InstitutionalProposalSpecialReview specialReview, String specialReviewType) {
        return StringUtils.equals((CharSequence)specialReview.getSpecialReviewTypeCode(), (CharSequence)specialReviewType) || specialReview.getSpecialReviewType() != null && StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getDescription(), (CharSequence)specialReviewType);
    }

    @Override
    public Boolean specialReviewAndApprovalTypeRule(InstitutionalProposal proposal, String specialReviewTypeCode, String approvalTypeCode) {
        List<InstitutionalProposalSpecialReview> specialReviews = proposal.getSpecialReviews();
        return this.specialReviewTypeCodeAndApprovalTypeCodeMatch(specialReviews, specialReviewTypeCode, approvalTypeCode);
    }
}

