/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.locking.LockRuntimeException;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockManagerRemoteImpl
implements LockManager,
Configurable {
    private Logger log = LoggerFactory.getLogger(LockManagerRemoteImpl.class);
    public static final byte METHOD_READ_LOCK = 97;
    public static final byte METHOD_WRITE_LOCK = 115;
    public static final byte METHOD_UPGRADE_LOCK = 117;
    public static final byte METHOD_CHECK_READ = 114;
    public static final byte METHOD_CHECK_WRITE = 119;
    public static final byte METHOD_CHECK_UPGRADE = 118;
    public static final byte METHOD_RELEASE_SINGLE_LOCK = 101;
    public static final byte METHOD_RELEASE_LOCKS = 120;
    public static final byte METHOD_LOCK_INFO = 105;
    public static final byte METHOD_LOCK_TIMEOUT = 116;
    public static final byte METHOD_LOCK_TIMEOUT_SET = 121;
    public static final byte METHOD_BLOCK_TIMEOUT = 99;
    public static final byte METHOD_BLOCK_TIMEOUT_SET = 100;
    private static URL lockservlet = null;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        String string = configuration.getString("LockServletUrl", "http://127.0.0.1:8080/ojb-lockserver");
        this.log.info("Lock server servlet URL: " + string);
        try {
            lockservlet = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("Invalid LockServlet Url was specified: " + string, malformedURLException);
        }
    }

    @Override
    public void setLockTimeout(long l) {
    }

    @Override
    public long getLockTimeout() {
        LockInfo lockInfo = new LockInfo(116);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequestLong(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Can't get locking info", throwable);
        }
    }

    @Override
    public long getBlockTimeout() {
        LockInfo lockInfo = new LockInfo(99);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequestLong(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Can't get block timeout value", throwable);
        }
    }

    @Override
    public void setBlockTimeout(long l) {
    }

    @Override
    public String getLockInfo() {
        LockInfo lockInfo = new LockInfo(105);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequestString(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Can't get locking info", throwable);
        }
    }

    @Override
    public boolean readLock(Object object, Object object2, int n) {
        LockInfo lockInfo = new LockInfo(object, object2, n, 97);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot check read lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    @Override
    public boolean releaseLock(Object object, Object object2) {
        LockInfo lockInfo = new LockInfo(object, object2, 101);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot remove write lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    @Override
    public void releaseLocks(Object object) {
        LockInfo lockInfo = new LockInfo(object, null, 120);
        try {
            byte[] byArray = this.serialize(lockInfo);
            this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot release locks using owner key '" + object + "'", throwable);
        }
    }

    @Override
    public boolean writeLock(Object object, Object object2, int n) {
        LockInfo lockInfo = new LockInfo(object, object2, n, 115);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot set write lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    @Override
    public boolean upgradeLock(Object object, Object object2, int n) {
        LockInfo lockInfo = new LockInfo(object, object2, n, 117);
        try {
            byte[] byArray = this.serialize(lockInfo);
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot set write lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    @Override
    public boolean hasRead(Object object, Object object2) {
        try {
            byte[] byArray = this.serialize(new LockInfo(object, object2, 114));
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot check read lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    @Override
    public boolean hasWrite(Object object, Object object2) {
        try {
            byte[] byArray = this.serialize(new LockInfo(object, object2, 119));
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot check write lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    @Override
    public boolean hasUpgrade(Object object, Object object2) {
        try {
            byte[] byArray = this.serialize(new LockInfo(object, object2, 118));
            return this.performRequest(byArray);
        }
        catch (Throwable throwable) {
            throw new LockRuntimeException("Cannot check write lock for '" + object2 + "' using key '" + object + "'", throwable);
        }
    }

    private HttpURLConnection getHttpUrlConnection() throws MalformedURLException, IOException, ProtocolException {
        URL uRL = this.getLockserverUrl();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setUseCaches(false);
        return httpURLConnection;
    }

    private URL getLockserverUrl() {
        return lockservlet;
    }

    public byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private boolean performRequest(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object = this.performRequestObject(byArray);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new LockRuntimeException("Remote lock server error, expect return value of type 'Boolean'");
    }

    private String performRequestString(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object = this.performRequestObject(byArray);
        if (object instanceof String) {
            return (String)object;
        }
        throw new LockRuntimeException("Remote lock server error, expect return value of type 'String'");
    }

    private long performRequestLong(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object = this.performRequestObject(byArray);
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new LockRuntimeException("Remote lock server error, expect return value of type 'String'");
    }

    private Object performRequestObject(byte[] byArray) throws IOException, ClassNotFoundException {
        HttpURLConnection httpURLConnection = this.getHttpUrlConnection();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        bufferedOutputStream.close();
        httpURLConnection.disconnect();
        if (object instanceof Throwable) {
            throw new LockRuntimeException("Remote lock server error", (Throwable)object);
        }
        return object;
    }

    public static final class LockInfo
    implements Serializable {
        public Object key;
        public Object resourceId;
        public int isolationLevel;
        public byte methodName;
        public long lockTimeout;
        public long blockTimeout;

        public LockInfo(byte by) {
            this.methodName = by;
        }

        public LockInfo(Object object, Object object2, byte by) {
            this.key = object;
            this.resourceId = object2;
            this.methodName = by;
        }

        public LockInfo(Object object, Object object2, int n, byte by) {
            this.key = object;
            this.resourceId = object2;
            this.isolationLevel = n;
            this.methodName = by;
        }
    }
}

