/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public final class CompatUtils {
    private static RouteHelper helper = new RouteHelper();

    private CompatUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Integer getLevelForNode(DocumentType documentType, String nodeName) {
        if (CompatUtils.isRouteLevelCompatible(documentType)) {
            return CompatUtils.getLevelForNode(documentType.getPrimaryProcess().getInitialRouteNode(), nodeName, 0);
        }
        return new Integer(-2);
    }

    private static Integer getLevelForNode(RouteNode node, String nodeName, Integer currentLevel) {
        if (node == null) {
            throw new WorkflowRuntimeException("Could not locate node with name '" + nodeName + "'");
        }
        if (node.getRouteNodeName().equals(nodeName)) {
            return currentLevel;
        }
        List<RouteNode> nextNodes = node.getNextNodes();
        if (nextNodes.isEmpty()) {
            throw new WorkflowRuntimeException("Could not locate node with name '" + nodeName + "'");
        }
        if (nextNodes.size() > 1) {
            throw new WorkflowRuntimeException("Can only determine route level for document types with no splitting");
        }
        RouteNode nextNode = nextNodes.get(0);
        return CompatUtils.getLevelForNode(nextNode, nodeName, new Integer(currentLevel + 1));
    }

    public static RouteNode getNodeForLevel(DocumentType documentType, Integer routeLevel) {
        RouteNode result = null;
        RouteNode initialRouteNode = documentType.getPrimaryProcess().getInitialRouteNode();
        if (initialRouteNode != null) {
            Object[] node = CompatUtils.getNodeForLevel(initialRouteNode, routeLevel, new Integer(0));
            result = (RouteNode)node[0];
        }
        return result;
    }

    private static Object[] getNodeForLevel(RouteNode node, Integer routeLevel, Integer currentLevel) {
        if (helper.isSubProcessNode(node)) {
            Object[] result = CompatUtils.getNodeForLevel(node.getDocumentType().getNamedProcess(node.getRouteNodeName()).getInitialRouteNode(), routeLevel, currentLevel);
            if (result[0] != null) {
                node = (RouteNode)result[0];
            }
            currentLevel = (Integer)result[1];
        }
        if (currentLevel.equals(routeLevel)) {
            return new Object[]{node, currentLevel};
        }
        List<RouteNode> nextNodes = node.getNextNodes();
        if (nextNodes.isEmpty()) {
            return new Object[]{null, currentLevel};
        }
        if (nextNodes.size() > 1) {
            throw new WorkflowRuntimeException("Cannot determine a route level number for documents with splitting.");
        }
        currentLevel = new Integer(currentLevel + 1);
        return CompatUtils.getNodeForLevel(nextNodes.get(0), routeLevel, currentLevel);
    }

    public static boolean isRouteLevelCompatible(DocumentType documentType) {
        return "1".equals(documentType.getRoutingVersion());
    }

    public static boolean isRouteLevelCompatible(DocumentRouteHeaderValue document) {
        return CompatUtils.isRouteLevelCompatible(document.getDocumentType());
    }

    public static boolean isNodalDocument(DocumentRouteHeaderValue document) {
        return 1 == document.getDocVersion();
    }

    public static boolean isNodalRequest(ActionRequestValue request) {
        return 1 == request.getDocVersion();
    }

    public static boolean isRouteLevelDocument(DocumentRouteHeaderValue document) {
        return 0 == document.getDocVersion();
    }

    public static boolean isRouteLevelRequest(ActionRequestValue request) {
        return 0 == request.getDocVersion();
    }

    public static List<RouteNode> getRouteLevelCompatibleNodeList(DocumentType documentType) {
        if (!CompatUtils.isRouteLevelCompatible(documentType)) {
            throw new WorkflowRuntimeException("Attempting to invoke a 'route level' operation on a document which is not route level compatible.");
        }
        ProcessDefinitionBo primaryProcess = documentType.getPrimaryProcess();
        RouteNode routeNode = primaryProcess.getInitialRouteNode();
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        int count = 0;
        int maxCount = 100;
        if (routeNode != null) {
            while (true) {
                nodes.add(routeNode);
                List<RouteNode> nextNodes = routeNode.getNextNodes();
                if (nextNodes.size() == 0) break;
                if (nextNodes.size() > 1) {
                    throw new RuntimeException("Node has more than one next node!  It is not route level compatible!" + routeNode.getRouteNodeName());
                }
                if (count >= maxCount) {
                    throw new RuntimeException("A runaway loop was detected when attempting to create route level compatible node graph.  documentType=" + documentType.getDocumentTypeId() + "," + documentType.getName());
                }
                routeNode = nextNodes.iterator().next();
            }
        }
        return nodes;
    }

    public static int getMaxRouteLevel(DocumentType documentType) {
        return CompatUtils.getRouteLevelCompatibleNodeList(documentType).size();
    }
}

