/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.connect;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2SConfigurationReader;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class S2SConfigurationReaderBase
implements S2SConfigurationReader {
    private static final String JKS_TYPE = "JKS";
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    private String keyStoreLocationProperty;
    private String keyStorePasswordProperty;
    private String trustStoreLocationProperty;
    private String trustStorePasswordProperty;
    private String certAlgorithmProperty;
    private String serviceHostProperty;
    private String servicePortProperty;
    private String disableCNCheckProperty;
    private KeyStore keyStore = null;
    private KeyStore trustStore = null;

    @Override
    public String getKeyStoreLocation() {
        return this.getS2SConfigurationService().getValueAsString(this.keyStoreLocationProperty);
    }

    @Override
    public String getKeyStorePassword() {
        return this.getS2SConfigurationService().getValueAsString(this.keyStorePasswordProperty);
    }

    @Override
    public String getTrustStoreLocation() {
        return this.getS2SConfigurationService().getValueAsString(this.trustStoreLocationProperty);
    }

    @Override
    public String getTrustStorePassword() {
        return this.getS2SConfigurationService().getValueAsString(this.trustStorePasswordProperty);
    }

    @Override
    public KeyStore getKeyStore() throws S2sCommunicationException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        try {
            this.keyStore = KeyStore.getInstance(JKS_TYPE);
            this.keyStore.load(new FileInputStream(this.getKeyStoreLocation()), this.getKeyStorePassword().toCharArray());
        }
        catch (KeyStoreException e) {
            this.keyStore = null;
            throw new S2sCommunicationException("error.s2s.keystore.creation", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.keyStore = null;
            throw new S2sCommunicationException("error.s2s.keystore.no.algorithm", e);
        }
        catch (CertificateException e) {
            this.keyStore = null;
            throw new S2sCommunicationException("error.s2s.keystore.badcertificate", e);
        }
        catch (FileNotFoundException e) {
            this.keyStore = null;
            throw new S2sCommunicationException("error.s2s.keystore.not.found", e);
        }
        catch (IOException e) {
            this.keyStore = null;
            throw new S2sCommunicationException("error.s2s.keystore.cannot.read", e);
        }
        return this.keyStore;
    }

    @Override
    public KeyStore getKeyStoreAlias(String alias) throws S2sCommunicationException {
        KeyStore keyStoreAlias;
        try {
            keyStoreAlias = KeyStore.getInstance(JKS_TYPE);
            Certificate[] certificates = this.getKeyStore().getCertificateChain(alias);
            Key key = this.getKeyStore().getKey(alias, this.getKeyStorePassword().toCharArray());
            keyStoreAlias.load(null, null);
            keyStoreAlias.setKeyEntry(alias, key, this.getKeyStorePassword().toCharArray(), certificates);
        }
        catch (KeyStoreException e) {
            throw new S2sCommunicationException("error.s2s.keystore.creation", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new S2sCommunicationException("error.s2s.keystore.no.algorithm", e);
        }
        catch (CertificateException e) {
            throw new S2sCommunicationException("error.s2s.keystore.badcertificate", e);
        }
        catch (FileNotFoundException e) {
            throw new S2sCommunicationException("error.s2s.keystore.not.found", e);
        }
        catch (IOException e) {
            throw new S2sCommunicationException("error.s2s.keystore.cannot.read", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new S2sCommunicationException("error.s2s.keystore.creation", e);
        }
        return keyStoreAlias;
    }

    @Override
    public KeyStore getTrustStore() throws S2sCommunicationException {
        if (this.trustStore != null) {
            return this.trustStore;
        }
        try {
            this.trustStore = KeyStore.getInstance(JKS_TYPE);
            this.trustStore.load(new FileInputStream(this.getTrustStoreLocation()), this.getTrustStorePassword().toCharArray());
        }
        catch (KeyStoreException e) {
            this.trustStore = null;
            throw new S2sCommunicationException("error.s2s.truststore.creation", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.trustStore = null;
            throw new S2sCommunicationException("error.s2s.truststore.no.algorithm", e);
        }
        catch (CertificateException e) {
            this.trustStore = null;
            throw new S2sCommunicationException("error.s2s.truststore.badcertificate", e);
        }
        catch (FileNotFoundException e) {
            this.trustStore = null;
            throw new S2sCommunicationException("error.s2s.truststore.not.found", e);
        }
        catch (IOException e) {
            this.trustStore = null;
            throw new S2sCommunicationException("error.s2s.truststore.cannot.read", e);
        }
        return this.trustStore;
    }

    @Override
    public String getServiceHost() {
        return this.getS2SConfigurationService().getValueAsString(this.serviceHostProperty);
    }

    @Override
    public String getServicePort() {
        return this.getS2SConfigurationService().getValueAsString(this.servicePortProperty);
    }

    @Override
    public Boolean getDisableCNCheck() {
        return this.getS2SConfigurationService().getValueAsBoolean(this.disableCNCheckProperty);
    }

    @Override
    public String getCertAlgorithm() {
        return this.getS2SConfigurationService().getValueAsString(this.certAlgorithmProperty);
    }

    public String getKeyStoreLocationProperty() {
        return this.keyStoreLocationProperty;
    }

    public void setKeyStoreLocationProperty(String keyStoreLocationProperty) {
        this.keyStoreLocationProperty = keyStoreLocationProperty;
    }

    public String getKeyStorePasswordProperty() {
        return this.keyStorePasswordProperty;
    }

    public void setKeyStorePasswordProperty(String keyStorePasswordProperty) {
        this.keyStorePasswordProperty = keyStorePasswordProperty;
    }

    public String getTrustStoreLocationProperty() {
        return this.trustStoreLocationProperty;
    }

    public void setTrustStoreLocationProperty(String trustStoreLocationProperty) {
        this.trustStoreLocationProperty = trustStoreLocationProperty;
    }

    public String getTrustStorePasswordProperty() {
        return this.trustStorePasswordProperty;
    }

    public void setTrustStorePasswordProperty(String trustStorePasswordProperty) {
        this.trustStorePasswordProperty = trustStorePasswordProperty;
    }

    public String getCertAlgorithmProperty() {
        return this.certAlgorithmProperty;
    }

    public void setCertAlgorithmProperty(String certAlgorithmProperty) {
        this.certAlgorithmProperty = certAlgorithmProperty;
    }

    public String getServiceHostProperty() {
        return this.serviceHostProperty;
    }

    public void setServiceHostProperty(String serviceHostProperty) {
        this.serviceHostProperty = serviceHostProperty;
    }

    public String getServicePortProperty() {
        return this.servicePortProperty;
    }

    public void setServicePortProperty(String servicePortProperty) {
        this.servicePortProperty = servicePortProperty;
    }

    public String getDisableCNCheckProperty() {
        return this.disableCNCheckProperty;
    }

    public void setDisableCNCheckProperty(String disableCNCheckProperty) {
        this.disableCNCheckProperty = disableCNCheckProperty;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }
}

