/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.ActionSecurity;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="action", parent="Uif-Action"), @BeanTag(name="actionImage", parent="Uif-ActionImage"), @BeanTag(name="button", parent="Uif-PrimaryActionButton"), @BeanTag(name="secondaryButton", parent="Uif-SecondaryActionButton"), @BeanTag(name="buttonLarge", parent="Uif-PrimaryActionButton-Large"), @BeanTag(name="secondaryButtonLarge", parent="Uif-SecondaryActionButton-Large"), @BeanTag(name="buttonSmall", parent="Uif-PrimaryActionButton-Small"), @BeanTag(name="secondaryButtonSmall", parent="Uif-SecondaryActionButton-Small"), @BeanTag(name="buttonMini", parent="Uif-PrimaryActionButton-Mini"), @BeanTag(name="secondaryButtonMini", parent="Uif-SecondaryActionButton-Mini"), @BeanTag(name="actionLink", parent="Uif-ActionLink"), @BeanTag(name="navigationActionLink", parent="Uif-NavigationActionLink"), @BeanTag(name="navigationButton", parent="Uif-NavigationActionButton"), @BeanTag(name="secondaryNavigationActionButton", parent="Uif-SecondaryNavigationActionButton")})
public class Action
extends ContentElementBase {
    private static final long serialVersionUID = 1025672792657238829L;
    private String methodToCall;
    private String actionEvent;
    private String navigateToPageId;
    private List<String> fieldsToSend;
    private String actionScript;
    private UrlInfo actionUrl;
    private String actionLabel;
    private boolean renderInnerTextSpan;
    private Image actionImage;
    private String actionImagePlacement = UifConstants.Position.LEFT.name();
    private String iconClass;
    private String actionIconPlacement = UifConstants.Position.LEFT.name();
    private String jumpToIdAfterSubmit;
    private String jumpToNameAfterSubmit;
    private String focusOnIdAfterSubmit;
    private boolean performClientSideValidation;
    private boolean performDirtyValidation;
    private boolean clearDirtyOnAction;
    private boolean dirtyOnAction;
    private String preSubmitCall = "";
    private String confirmationPromptText;
    private DialogGroup confirmationDialog;
    private String dialogDismissOption;
    private String dialogResponse;
    private boolean ajaxSubmit = true;
    private String ajaxReturnType;
    private String refreshId;
    private String refreshPropertyName;
    private String successCallback = "";
    private String errorCallback = "";
    private String loadingMessageText;
    private boolean disableBlocking;
    private Map<String, String> additionalSubmitData = new HashMap<String, String>();
    private Map<String, String> actionParameters = new HashMap<String, String>();
    private boolean evaluateDisabledOnKeyUp;
    private boolean defaultEnterKeyAction;
    private boolean disabled = false;
    private String disabledReason;
    private String disabledExpression;
    private String disabledConditionJs;
    private List<String> disabledConditionControlNames;
    private List<String> disabledWhenChangedPropertyNames = new ArrayList<String>();
    private List<String> enabledWhenChangedPropertyNames = new ArrayList<String>();

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        this.disabledExpression = this.getPropertyExpression("disabled");
        if (this.disabledExpression != null) {
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            this.disabledExpression = expressionEvaluator.replaceBindingPrefixes(ViewLifecycle.getView(), this, this.disabledExpression);
            this.disabled = (Boolean)expressionEvaluator.evaluateExpression(this.getContext(), this.disabledExpression);
        }
        if (this.actionUrl != null) {
            ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(this.actionUrl, false);
            ViewLifecycle.getExpressionEvaluator().evaluateExpressionsOnConfigurable(ViewLifecycle.getView(), this.actionUrl, this.getContext());
        }
        if (StringUtils.isNotBlank((String)this.confirmationPromptText) && this.confirmationDialog != null && StringUtils.isBlank((String)this.confirmationDialog.getPromptText())) {
            this.confirmationDialog.setPromptText(this.confirmationPromptText);
        }
        this.addConfirmDialogToView();
    }

    protected void addConfirmDialogToView() {
        if (StringUtils.isBlank((String)this.confirmationPromptText) || this.confirmationDialog != null) {
            return;
        }
        boolean containsYesNoDialog = false;
        List<Group> viewDialogs = ViewLifecycle.getView().getDialogs();
        if (viewDialogs == null) {
            viewDialogs = new ArrayList<Group>();
        } else {
            for (Group dialogGroup : viewDialogs) {
                if (!StringUtils.equals((String)"Uif-DialogGroup-YesNo", (String)dialogGroup.getId())) continue;
                containsYesNoDialog = true;
            }
        }
        if (!containsYesNoDialog) {
            DialogGroup confirmDialog = ComponentFactory.getYesNoDialog();
            confirmDialog.setId("Uif-DialogGroup-YesNo");
            viewDialogs.add(confirmDialog);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        View view = ViewLifecycle.getView();
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        if (StringUtils.isNotEmpty((String)this.disabledExpression) && !this.disabledExpression.equalsIgnoreCase("true") && !this.disabledExpression.equalsIgnoreCase("false")) {
            this.disabledConditionControlNames = new ArrayList<String>();
            this.disabledConditionJs = ViewLifecycle.getExpressionEvaluator().parseExpression(this.disabledExpression, this.disabledConditionControlNames, this.getContext());
        }
        ArrayList<String> adjustedDisablePropertyNames = new ArrayList<String>();
        for (String string : this.disabledWhenChangedPropertyNames) {
            adjustedDisablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, string));
        }
        this.disabledWhenChangedPropertyNames = adjustedDisablePropertyNames;
        ArrayList<String> adjustedEnablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.enabledWhenChangedPropertyNames) {
            adjustedEnablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.enabledWhenChangedPropertyNames = adjustedEnablePropertyNames;
        if (this.actionImage != null && StringUtils.isNotBlank((String)this.actionImagePlacement) && StringUtils.isNotBlank((String)this.actionLabel)) {
            this.actionImage.setAltText("");
        }
        if (StringUtils.isNotBlank((String)this.iconClass) && ("ICON_ONLY".equals(this.actionIconPlacement) || StringUtils.isBlank((String)this.actionLabel))) {
            this.getCssClasses().add(this.iconClass);
            this.actionIconPlacement = "ICON_ONLY";
        }
        if (!this.actionParameters.containsKey("actionEvent") && StringUtils.isNotBlank((String)this.actionEvent)) {
            this.actionParameters.put("actionEvent", this.actionEvent);
        }
        if (StringUtils.isNotBlank((String)this.navigateToPageId)) {
            this.actionParameters.put("navigateToPageId", this.navigateToPageId);
            if (StringUtils.isBlank((String)this.methodToCall)) {
                this.methodToCall = "navigate";
            }
        }
        if (!this.actionParameters.containsKey("methodToCall") && StringUtils.isNotBlank((String)this.methodToCall)) {
            this.actionParameters.put("methodToCall", this.methodToCall);
        }
        this.setupRefreshAction(view);
        if (view instanceof FormView) {
            boolean bl = this.performDirtyValidation = this.performDirtyValidation && ((FormView)view).isApplyDirtyCheck();
        }
        if (StringUtils.isBlank((String)this.getActionScript()) && this.actionUrl != null && this.actionUrl.isFullyConfigured()) {
            void var7_12;
            if (this.actionUrl.getTarget() == null) {
                String string = ScriptUtils.buildFunctionCall("redirect", this.actionUrl.getHref());
            } else if (UrlInfo.TargetFrame.BLANK == this.actionUrl.getTarget()) {
                String string = ScriptUtils.buildFunctionCall("popout", this.actionUrl.getHref());
            } else {
                String string = ScriptUtils.buildFunctionCall("redirect", this.actionUrl.getHref()).replace(")", ", " + this.actionUrl.getTarget().name().toLowerCase() + ")");
            }
            this.setActionScript((String)var7_12);
            if (StringUtils.isNotBlank((String)this.actionUrl.getMethodToCall())) {
                ViewLifecycle.getViewPostMetadata().addAvailableMethodToCall(this.actionUrl.getMethodToCall());
            }
        }
        if (StringUtils.isBlank((String)this.getActionScript()) && StringUtils.isNotBlank((String)this.methodToCall)) {
            ViewLifecycle.getViewPostMetadata().addAvailableMethodToCall(this.methodToCall);
        }
        if (this.isRender()) {
            for (String additionalSubmitPath : this.additionalSubmitData.keySet()) {
                ViewLifecycle.getViewPostMetadata().addAccessibleBindingPath(additionalSubmitPath);
            }
            if (this.actionUrl != null && this.actionUrl.isFullyConfigured() && StringUtils.isNotBlank((String)this.actionUrl.getMethodToCall())) {
                ViewLifecycle.getViewPostMetadata().addAccessibleMethodToCall(this.actionUrl.getMethodToCall());
            } else if (StringUtils.isBlank((String)this.getActionScript()) && StringUtils.isNotBlank((String)this.methodToCall)) {
                ViewLifecycle.getViewPostMetadata().addAccessibleMethodToCall(this.methodToCall);
            }
        }
        this.buildActionData(view, model, parent);
    }

    protected void setupRefreshAction(View view) {
        Component component;
        if (StringUtils.isNotBlank((String)this.refreshPropertyName) || StringUtils.isNotBlank((String)this.refreshId)) {
            this.ajaxReturnType = UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey();
        }
        Component refreshComponent = null;
        if (StringUtils.isNotBlank((String)this.refreshPropertyName)) {
            if (this.refreshPropertyName.startsWith("#form.")) {
                this.refreshPropertyName = StringUtils.removeStart((String)this.refreshPropertyName, (String)"#form.");
            } else if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath())) {
                this.refreshPropertyName = view.getDefaultBindingObjectPath() + "." + this.refreshPropertyName;
            }
            DataField dataField = view.getViewIndex().getDataFieldByPath(this.refreshPropertyName);
            if (dataField != null) {
                refreshComponent = dataField;
                this.refreshId = refreshComponent.getId();
            }
        } else if (StringUtils.isNotBlank((String)this.refreshId) && (component = view.getViewIndex().getComponentById(this.refreshId)) != null) {
            refreshComponent = component;
        }
        if (refreshComponent != null) {
            refreshComponent.setRefreshedByAction(true);
        }
    }

    protected void buildActionData(View view, Object model, LifecycleElement parent) {
        HashMap<String, String> actionDataAttributes = new HashMap<String, String>();
        Map dataDefaults = (Map)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-Action-DataDefaults");
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "ajaxSubmit", Boolean.toString(this.ajaxSubmit));
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "successCallback", this.successCallback);
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "errorCallback", this.errorCallback);
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "preSubmitCall", this.preSubmitCall);
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "loadingMessage", this.loadingMessageText);
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "disableBlocking", Boolean.toString(this.disableBlocking));
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "ajaxReturnType", this.ajaxReturnType);
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "refreshId", this.refreshId);
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "validate", Boolean.toString(this.performClientSideValidation));
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "dirtyOnAction", Boolean.toString(this.dirtyOnAction));
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "clearDirtyOnAction", Boolean.toString(this.clearDirtyOnAction));
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "performDirtyValidation", Boolean.toString(this.performDirtyValidation));
        if (CollectionUtils.isNotEmpty(this.fieldsToSend)) {
            this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "fieldsToSend", ScriptUtils.translateValue(this.fieldsToSend));
        }
        if (this.confirmationDialog != null) {
            this.addDataAttribute("confirmDialogId", this.confirmationDialog.getId());
        } else if (StringUtils.isNotBlank((String)this.confirmationPromptText)) {
            this.addDataAttribute("confirm_prompttext", this.confirmationPromptText);
        }
        if (StringUtils.isNotBlank((String)this.dialogDismissOption)) {
            this.addDataAttribute("dismissdialogoption", this.dialogDismissOption);
        }
        if (StringUtils.isNotBlank((String)this.dialogResponse)) {
            this.addDataAttribute("response", this.dialogResponse);
        }
        HashMap<String, String> submitData = new HashMap<String, String>();
        for (String key : this.actionParameters.keySet()) {
            Object parameterPath = key;
            if (!key.equals("methodToCall")) {
                parameterPath = "actionParameters[" + key + "]";
            }
            submitData.put((String)parameterPath, this.actionParameters.get(key));
        }
        for (String key : this.additionalSubmitData.keySet()) {
            submitData.put(key, this.additionalSubmitData.get(key));
        }
        if (this.focusOnIdAfterSubmit.equalsIgnoreCase(UifConstants.Order.NEXT_INPUT.toString())) {
            this.focusOnIdAfterSubmit = UifConstants.Order.NEXT_INPUT.toString() + ":" + this.getId();
        }
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "focusId", this.focusOnIdAfterSubmit);
        if (StringUtils.isNotBlank((String)this.jumpToIdAfterSubmit)) {
            this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "jumpToId", this.jumpToIdAfterSubmit);
        } else if (StringUtils.isNotBlank((String)this.jumpToNameAfterSubmit)) {
            this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "jumpToName", this.jumpToNameAfterSubmit);
        }
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "submit_data", ScriptUtils.toJSON(submitData));
        String onClickScript = this.getOnClickScript();
        onClickScript = StringUtils.isNotBlank((String)this.actionScript) ? ScriptUtils.appendScript(onClickScript, this.actionScript) : ScriptUtils.appendScript(onClickScript, "actionInvokeHandler(this);");
        if (this.disabled) {
            this.addStyleClass("disabled");
            this.setSkipInTabOrder(true);
        }
        this.addActionDataSettingsValue(actionDataAttributes, dataDefaults, "onClick", KRADUtils.convertToHTMLAttributeSafeString(onClickScript));
        if (!actionDataAttributes.isEmpty()) {
            this.getDataAttributes().putAll(actionDataAttributes);
        }
        this.addDataAttribute("role", "Action");
        if (this.isDefaultEnterKeyAction()) {
            this.addDataAttribute("default_enter_key_action", Boolean.toString(this.isDefaultEnterKeyAction()));
        }
    }

    protected void addActionDataSettingsValue(Map<String, String> valueMap, Map<String, String> defaults, String key, String value) {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        String defaultValue = defaults.get(key);
        if (defaultValue == null || !value.equals(defaultValue)) {
            valueMap.put(key, value);
        }
    }

    @BeanTagAttribute
    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @BeanTagAttribute
    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    @BeanTagAttribute
    public boolean isRenderInnerTextSpan() {
        return this.renderInnerTextSpan;
    }

    public void setRenderInnerTextSpan(boolean renderInnerTextSpan) {
        this.renderInnerTextSpan = renderInnerTextSpan;
    }

    @BeanTagAttribute
    public Image getActionImage() {
        return this.actionImage;
    }

    public void setActionImage(Image actionImage) {
        this.actionImage = actionImage;
    }

    @BeanTagAttribute
    public String getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    @BeanTagAttribute
    public String getNavigateToPageId() {
        return this.navigateToPageId;
    }

    public void setNavigateToPageId(String navigateToPageId) {
        this.navigateToPageId = navigateToPageId;
    }

    @BeanTagAttribute
    public List<String> getFieldsToSend() {
        return this.fieldsToSend;
    }

    public void setFieldsToSend(List<String> fieldsToSend) {
        this.fieldsToSend = fieldsToSend;
    }

    @BeanTagAttribute
    public String getActionEvent() {
        return this.actionEvent;
    }

    public void setActionEvent(String actionEvent) {
        this.actionEvent = actionEvent;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalSubmitData() {
        return this.additionalSubmitData;
    }

    public void setAdditionalSubmitData(Map<String, String> additionalSubmitData) {
        this.additionalSubmitData = additionalSubmitData;
    }

    @BeanTagAttribute
    public Map<String, String> getActionParameters() {
        return this.actionParameters;
    }

    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public void addActionParameter(String parameterName, String parameterValue) {
        if (this.actionParameters == null) {
            this.actionParameters = new HashMap<String, String>();
        }
        this.actionParameters.put(parameterName, parameterValue);
    }

    public String getActionParameter(String parameterName) {
        return this.actionParameters.get(parameterName);
    }

    public ActionSecurity getActionSecurity() {
        return (ActionSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof ActionSecurity)) {
            throw new RiceRuntimeException("Component security for Action should be instance of ActionSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected void initializeComponentSecurity() {
        if (this.getComponentSecurity() == null) {
            this.setComponentSecurity(KRADUtils.createNewObjectFromClass(ActionSecurity.class));
        }
    }

    @BeanTagAttribute
    public boolean isPerformActionAuthz() {
        this.initializeComponentSecurity();
        return this.getActionSecurity().isPerformActionAuthz();
    }

    public void setPerformActionAuthz(boolean performActionAuthz) {
        this.initializeComponentSecurity();
        this.getActionSecurity().setPerformActionAuthz(performActionAuthz);
    }

    @BeanTagAttribute
    public boolean isPerformLineActionAuthz() {
        this.initializeComponentSecurity();
        return this.getActionSecurity().isPerformLineActionAuthz();
    }

    public void setPerformLineActionAuthz(boolean performLineActionAuthz) {
        this.initializeComponentSecurity();
        this.getActionSecurity().setPerformLineActionAuthz(performLineActionAuthz);
    }

    @BeanTagAttribute
    public String getJumpToIdAfterSubmit() {
        return this.jumpToIdAfterSubmit;
    }

    public void setJumpToIdAfterSubmit(String jumpToIdAfterSubmit) {
        this.jumpToIdAfterSubmit = jumpToIdAfterSubmit;
    }

    @BeanTagAttribute
    public String getJumpToNameAfterSubmit() {
        return this.jumpToNameAfterSubmit;
    }

    public void setJumpToNameAfterSubmit(String jumpToNameAfterSubmit) {
        this.jumpToNameAfterSubmit = jumpToNameAfterSubmit;
    }

    @BeanTagAttribute
    public String getFocusOnIdAfterSubmit() {
        return this.focusOnIdAfterSubmit;
    }

    public void setFocusOnIdAfterSubmit(String focusOnIdAfterSubmit) {
        this.focusOnIdAfterSubmit = focusOnIdAfterSubmit;
    }

    @BeanTagAttribute
    public boolean isPerformClientSideValidation() {
        return this.performClientSideValidation;
    }

    public void setPerformClientSideValidation(boolean performClientSideValidation) {
        this.performClientSideValidation = performClientSideValidation;
    }

    @BeanTagAttribute
    public String getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(String actionScript) {
        if (StringUtils.isNotBlank((String)actionScript) && !StringUtils.endsWith((String)actionScript, (String)";")) {
            actionScript = (String)actionScript + ";";
        }
        this.actionScript = actionScript;
    }

    @BeanTagAttribute
    public UrlInfo getActionUrl() {
        return this.actionUrl;
    }

    public void setActionUrl(UrlInfo actionUrl) {
        this.actionUrl = actionUrl;
    }

    public void setPerformDirtyValidation(boolean performDirtyValidation) {
        this.performDirtyValidation = performDirtyValidation;
    }

    @BeanTagAttribute
    public boolean isPerformDirtyValidation() {
        return this.performDirtyValidation;
    }

    @BeanTagAttribute
    public boolean isClearDirtyOnAction() {
        return this.clearDirtyOnAction;
    }

    public void setClearDirtyOnAction(boolean clearDirtyOnAction) {
        this.clearDirtyOnAction = clearDirtyOnAction;
    }

    @BeanTagAttribute
    public boolean isDirtyOnAction() {
        return this.dirtyOnAction;
    }

    public void setDirtyOnAction(boolean dirtyOnAction) {
        this.dirtyOnAction = dirtyOnAction;
    }

    @BeanTagAttribute
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @BeanTagAttribute
    public String getDisabledReason() {
        return this.disabledReason;
    }

    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    @BeanTagAttribute
    public String getActionImagePlacement() {
        return this.actionImagePlacement;
    }

    public void setActionImagePlacement(String actionImagePlacement) {
        this.actionImagePlacement = actionImagePlacement;
    }

    @BeanTagAttribute
    public String getActionIconPlacement() {
        return this.actionIconPlacement;
    }

    public void setActionIconPlacement(String actionIconPlacement) {
        this.actionIconPlacement = actionIconPlacement;
    }

    @BeanTagAttribute
    public String getPreSubmitCall() {
        return this.preSubmitCall;
    }

    public void setPreSubmitCall(String preSubmitCall) {
        this.preSubmitCall = preSubmitCall;
    }

    public String getConfirmationPromptText() {
        return this.confirmationPromptText;
    }

    public void setConfirmationPromptText(String confirmationPromptText) {
        this.confirmationPromptText = confirmationPromptText;
    }

    public DialogGroup getConfirmationDialog() {
        return this.confirmationDialog;
    }

    public void setConfirmationDialog(DialogGroup confirmationDialog) {
        this.confirmationDialog = confirmationDialog;
    }

    public String getDialogDismissOption() {
        return this.dialogDismissOption;
    }

    public void setDialogDismissOption(String dialogDismissOption) {
        this.dialogDismissOption = dialogDismissOption;
    }

    public String getDialogResponse() {
        return this.dialogResponse;
    }

    public void setDialogResponse(String dialogResponse) {
        this.dialogResponse = dialogResponse;
    }

    @BeanTagAttribute
    public boolean isAjaxSubmit() {
        return this.ajaxSubmit;
    }

    public void setAjaxSubmit(boolean ajaxSubmit) {
        this.ajaxSubmit = ajaxSubmit;
    }

    @BeanTagAttribute
    public String getAjaxReturnType() {
        return this.ajaxReturnType;
    }

    public void setAjaxReturnType(String ajaxReturnType) {
        this.ajaxReturnType = ajaxReturnType;
    }

    @BeanTagAttribute
    public boolean isDisplayResponseInLightBox() {
        return StringUtils.equals((String)this.ajaxReturnType, (String)UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey());
    }

    public void setDisplayResponseInLightBox(boolean displayResponseInLightBox) {
        if (displayResponseInLightBox) {
            this.ajaxReturnType = UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey();
        } else if (StringUtils.equals((String)this.ajaxReturnType, (String)UifConstants.AjaxReturnTypes.DISPLAYLIGHTBOX.getKey())) {
            this.ajaxReturnType = UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey();
        }
    }

    @BeanTagAttribute
    public String getSuccessCallback() {
        return this.successCallback;
    }

    public void setSuccessCallback(String successCallback) {
        this.successCallback = successCallback;
    }

    @BeanTagAttribute
    public String getErrorCallback() {
        return this.errorCallback;
    }

    public void setErrorCallback(String errorCallback) {
        this.errorCallback = errorCallback;
    }

    @BeanTagAttribute
    public String getRefreshId() {
        return this.refreshId;
    }

    public void setRefreshId(String refreshId) {
        this.refreshId = refreshId;
    }

    @BeanTagAttribute
    public String getRefreshPropertyName() {
        return this.refreshPropertyName;
    }

    public void setRefreshPropertyName(String refreshPropertyName) {
        this.refreshPropertyName = refreshPropertyName;
    }

    @BeanTagAttribute
    public String getLoadingMessageText() {
        return this.loadingMessageText;
    }

    public void setLoadingMessageText(String loadingMessageText) {
        this.loadingMessageText = loadingMessageText;
    }

    @BeanTagAttribute
    public boolean isDisableBlocking() {
        return this.disableBlocking;
    }

    public void setDisableBlocking(boolean disableBlocking) {
        this.disableBlocking = disableBlocking;
    }

    @BeanTagAttribute
    public boolean isEvaluateDisabledOnKeyUp() {
        return this.evaluateDisabledOnKeyUp;
    }

    public void setEvaluateDisabledOnKeyUp(boolean evaluateDisabledOnKeyUp) {
        this.evaluateDisabledOnKeyUp = evaluateDisabledOnKeyUp;
    }

    @BeanTagAttribute(name="defaultEnterKeyAction")
    public boolean isDefaultEnterKeyAction() {
        return this.defaultEnterKeyAction;
    }

    public void setDefaultEnterKeyAction(boolean defaultEnterKeyAction) {
        this.defaultEnterKeyAction = defaultEnterKeyAction;
    }

    public String getDisabledConditionJs() {
        return this.disabledConditionJs;
    }

    protected void setDisabledConditionJs(String disabledConditionJs) {
        this.disabledConditionJs = disabledConditionJs;
    }

    public List<String> getDisabledConditionControlNames() {
        return this.disabledConditionControlNames;
    }

    public void setDisabledConditionControlNames(List<String> disabledConditionControlNames) {
        this.disabledConditionControlNames = disabledConditionControlNames;
    }

    @BeanTagAttribute
    public List<String> getDisabledWhenChangedPropertyNames() {
        return this.disabledWhenChangedPropertyNames;
    }

    public void setDisabledWhenChangedPropertyNames(List<String> disabledWhenChangedPropertyNames) {
        this.disabledWhenChangedPropertyNames = disabledWhenChangedPropertyNames;
    }

    @BeanTagAttribute
    public List<String> getEnabledWhenChangedPropertyNames() {
        return this.enabledWhenChangedPropertyNames;
    }

    public void setEnabledWhenChangedPropertyNames(List<String> enabledWhenChangedPropertyNames) {
        this.enabledWhenChangedPropertyNames = enabledWhenChangedPropertyNames;
    }

    protected void setDisabledExpression(String disabledExpression) {
        this.disabledExpression = disabledExpression;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getJumpToIdAfterSubmit() != null && this.getJumpToNameAfterSubmit() != null) {
            String[] currentValues = new String[]{"jumpToIdAfterSubmit =" + this.getJumpToIdAfterSubmit(), "jumpToNameAfterSubmit =" + this.getJumpToNameAfterSubmit()};
            tracer.createWarning("Only 1 jumpTo property should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

