/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.NotificationProducerContract;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREN_PRODCR_T")
public class NotificationProducerBo
extends PersistableBusinessObjectBase
implements NotificationProducerContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Id
    @GeneratedValue(generator="KREN_PRODCR_S")
    @PortableSequenceGenerator(name="KREN_PRODCR_S")
    @Column(name="PRODCR_ID")
    private Long id;
    @Column(name="NM", nullable=false)
    private String name;
    @Column(name="DESC_TXT", nullable=false)
    private String description;
    @Column(name="CNTCT_INFO", nullable=false)
    private String contactInfo;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="KREN_CHNL_PRODCR_T", joinColumns={@JoinColumn(name="PRODCR_ID")}, inverseJoinColumns={@JoinColumn(name="CHNL_ID")})
    @OrderBy(value="id ASC")
    private List<NotificationChannelBo> channels;
    static final long serialVersionUID = -7515019519351483612L;

    public NotificationProducerBo() {
        this.channels = new ArrayList<NotificationChannelBo>();
    }

    public String getContactInfo() {
        return this._persistence_get_contactInfo();
    }

    public List<Long> getChannelIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NotificationChannelBo bo : this.getChannels()) {
            ids.add(bo.getId());
        }
        return ids;
    }

    public void setContactInfo(String contactInfo) {
        this._persistence_set_contactInfo(contactInfo);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public Long getId() {
        return this._persistence_get_id();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public List<NotificationChannelBo> getChannels() {
        return this._persistence_get_channels();
    }

    public void setChannels(List<NotificationChannelBo> channels) {
        this._persistence_set_channels(channels);
    }

    public static NotificationProducer to(NotificationProducerBo bo) {
        if (bo == null) {
            return null;
        }
        return NotificationProducer.Builder.create((NotificationProducerContract)bo).build();
    }

    public static NotificationProducerBo from(NotificationProducer im) {
        if (im == null) {
            return null;
        }
        NotificationProducerBo bo = new NotificationProducerBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setContactInfo(im.getContactInfo());
        ArrayList<NotificationChannelBo> tempChannels = new ArrayList<NotificationChannelBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getChannelIds())) {
            NotificationChannelService ncs = (NotificationChannelService)GlobalResourceLoader.getService((String)"notificationChannelService");
            for (Long channelId : im.getChannelIds()) {
                tempChannels.add(ncs.getNotificationChannel(channelId.toString()));
            }
            bo.setChannels(tempChannels);
        }
        return bo;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NotificationProducerBo(persistenceObject);
    }

    public NotificationProducerBo(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "contactInfo") {
            return this.contactInfo;
        }
        if (string == "channels") {
            return this.channels;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "id") {
            return this.id;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "contactInfo") {
            this.contactInfo = (String)object;
            return;
        }
        if (string == "channels") {
            this.channels = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_contactInfo() {
        this._persistence_checkFetched("contactInfo");
        return this.contactInfo;
    }

    public void _persistence_set_contactInfo(String string) {
        this._persistence_checkFetchedForSet("contactInfo");
        this.contactInfo = string;
    }

    public List _persistence_get_channels() {
        this._persistence_checkFetched("channels");
        return this.channels;
    }

    public void _persistence_set_channels(List list) {
        this._persistence_checkFetchedForSet("channels");
        this.channels = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this.id = l;
    }
}

