/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.api.namespace;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.coreservice.api.namespace.NamespaceContract;
import org.w3c.dom.Element;

@XmlRootElement(name="namespace")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="NamespaceType", propOrder={"code", "applicationId", "name", "active", "versionNumber", "objectId", "_futureElements"})
public final class Namespace
extends AbstractDataTransferObject
implements NamespaceContract {
    private static final long serialVersionUID = -5206398776503106883L;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="applicationId", required=false)
    private final String applicationId;
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Namespace() {
        this.code = null;
        this.applicationId = null;
        this.name = null;
        this.active = true;
        this.versionNumber = null;
        this.objectId = null;
    }

    private Namespace(Builder builder) {
        this.code = builder.getCode();
        this.applicationId = builder.getApplicationId();
        this.name = builder.getName();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/core/v2_0/NamespaceType";
    }

    static class Elements {
        static final String CODE = "code";
        static final String APPLICATION_ID = "applicationId";
        static final String NAME = "name";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "namespace";
        static final String TYPE_NAME = "NamespaceType";

        Constants() {
        }
    }

    public static final class Builder
    implements NamespaceContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -70194982373806749L;
        private String code;
        private String applicationId;
        private String name;
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder(String code) {
            this.setCode(code);
            this.setActive(true);
        }

        public static Builder create(String code) {
            return new Builder(code);
        }

        public static Builder create(String code, String applicationId) {
            Builder builder = new Builder(code);
            builder.setApplicationId(applicationId);
            return builder;
        }

        public static Builder create(NamespaceContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = new Builder(contract.getCode());
            builder.setApplicationId(contract.getApplicationId());
            builder.setName(contract.getName());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code is blank");
            }
            this.code = code;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public String getCode() {
            return this.code;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public Namespace build() {
            return new Namespace(this);
        }
    }
}

