/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.subaward.status;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;
import org.kuali.coeus.dc.subaward.status.SubawardStatusDao;

public class SubawardStatusDaoImpl
implements SubawardStatusDao {
    private static final Logger LOG = Logger.getLogger(SubawardStatusDaoImpl.class.getName());
    private static final String ALL_DISTINCT_SUBAWARDS = "select distinct subaward_code from subaward t";
    private static final String BACKUP_SUBAWARD = "CREATE TABLE SUBAWARD_BAK_1610_005 AS SELECT * FROM SUBAWARD";
    private static final String BACKUP_VERSION_HISTORY = "CREATE TABLE VH_SUBAWARD_BAK_1610_005 AS SELECT * FROM VERSION_HISTORY WHERE SEQ_OWNER_CLASS_NAME = 'org.kuali.kra.subaward.bo.SubAward'";
    private static final String HIGHEST_SEQ_SUBAWARD_DOC_NUM = "select t.DOCUMENT_NUMBER, t.sequence_number from subaward t where t.sequence_number = (select max(sequence_number) from subaward u where u.subaward_code = t.subaward_code) and t.subaward_code = ?";
    private static final String SUBAWARDS_LESS_THAN_SEQ = "select t.DOCUMENT_NUMBER, t.sequence_number from subaward t where sequence_number < ? and subaward_code = ? order by t.SEQUENCE_NUMBER desc";
    private static final String KEW_DOC_STATUS = "select DOC_HDR_STAT_CD from KREW_DOC_HDR_T where DOC_HDR_ID = ?";
    private static final String UPDATE_SINGLE_SEQ = "update subaward set SUBAWARD_SEQUENCE_STATUS = ? where sequence_number = ? and subaward_code = ?";
    private static final String UPDATE_SINGLE_SEQ_VH = "update VERSION_HISTORY set VERSION_STATUS = ? where SEQ_OWNER_SEQ_NUMBER = ? and SEQ_OWNER_VERSION_NAME_VALUE = ? and SEQ_OWNER_CLASS_NAME = 'org.kuali.kra.subaward.bo.SubAward'";
    private static final String FINAL_CD = "F";
    private static final String PROCESSED_CD = "P";
    private static final String DISAPPROVED_CD = "D";
    private static final String CANCELED_CD = "X";
    private static final String CANCELED_DISAPPROVED_CD = "C";
    private static final String ACTIVE = "ACTIVE";
    private static final String CANCELED = "CANCELED";
    private static final String PENDING = "PENDING";
    private static final String ARCHIVED = "ARCHIVED";
    private ConnectionDaoService connectionDaoService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fixSubawardStatus() {
        PreparedStatement statement;
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try {
            statement = connection.prepareStatement(BACKUP_SUBAWARD);
            try {
                statement.execute();
                LOG.info("created backup of SUBAWARD table");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "failed to create backup of SUBAWARD table", e);
        }
        try {
            statement = connection.prepareStatement(BACKUP_VERSION_HISTORY);
            try {
                statement.execute();
                LOG.info("created backup of VERSION_HISTORY table for SUBAWARD records");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "failed to create backup of VERSION_HISTORY table for SUBAWARD records", e);
        }
        try (PreparedStatement subawardsStatement = connection.prepareStatement(ALL_DISTINCT_SUBAWARDS);
             ResultSet subawardsResult = subawardsStatement.executeQuery();){
            while (subawardsResult.next()) {
                String subawardCode = subawardsResult.getString(1);
                PreparedStatement highestStatement = PreparedStatementUtils.setString(1, subawardCode, connection.prepareStatement(HIGHEST_SEQ_SUBAWARD_DOC_NUM));
                try {
                    ResultSet highestResult = highestStatement.executeQuery();
                    try {
                        if (!highestResult.next()) continue;
                        String documentNumber = highestResult.getString(1);
                        int sequenceNumber = highestResult.getInt(2);
                        String kewStatus = this.getKewStatus(documentNumber);
                        if (FINAL_CD.equals(kewStatus) || PROCESSED_CD.equals(kewStatus) || kewStatus == null) {
                            this.updateSingleSeq(subawardCode, sequenceNumber, ACTIVE);
                            this.updateLessThanSeq(subawardCode, sequenceNumber, false);
                            continue;
                        }
                        if (DISAPPROVED_CD.equals(kewStatus) || CANCELED_CD.equals(kewStatus) || CANCELED_DISAPPROVED_CD.equals(kewStatus)) {
                            this.updateSingleSeq(subawardCode, sequenceNumber, CANCELED);
                            this.updateLessThanSeq(subawardCode, sequenceNumber, true);
                            continue;
                        }
                        this.updateSingleSeq(subawardCode, sequenceNumber, PENDING);
                        this.updateLessThanSeq(subawardCode, sequenceNumber, true);
                    }
                    finally {
                        if (highestResult == null) continue;
                        highestResult.close();
                    }
                }
                finally {
                    if (highestStatement == null) continue;
                    highestStatement.close();
                }
            }
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateSingleSeq(String subawardCode, int sequenceNumber, String status) {
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement statement = connection.prepareStatement(UPDATE_SINGLE_SEQ);
             PreparedStatement vhStatement = connection.prepareStatement(UPDATE_SINGLE_SEQ_VH);){
            statement.setString(1, status);
            statement.setInt(2, sequenceNumber);
            statement.setString(3, subawardCode);
            statement.executeUpdate();
            vhStatement.setString(1, status);
            vhStatement.setInt(2, sequenceNumber);
            vhStatement.setString(3, subawardCode);
            vhStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateLessThanSeq(String subawardCode, int sequenceNumber, boolean findActive) {
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement statement = PreparedStatementUtils.setString(2, subawardCode, PreparedStatementUtils.setInt(1, sequenceNumber, connection.prepareStatement(SUBAWARDS_LESS_THAN_SEQ)));
             ResultSet result = statement.executeQuery();){
            boolean activeFound = false;
            while (result.next()) {
                String currentDocumentNumber = result.getString(1);
                int currentSequenceNumber = result.getInt(2);
                String kewStatus = this.getKewStatus(currentDocumentNumber);
                if ((FINAL_CD.equals(kewStatus) || PROCESSED_CD.equals(kewStatus) || kewStatus == null) && findActive && !activeFound) {
                    this.updateSingleSeq(subawardCode, currentSequenceNumber, ACTIVE);
                    activeFound = true;
                    continue;
                }
                if (DISAPPROVED_CD.equals(kewStatus) || CANCELED_CD.equals(kewStatus) || CANCELED_DISAPPROVED_CD.equals(kewStatus)) {
                    this.updateSingleSeq(subawardCode, currentSequenceNumber, CANCELED);
                    continue;
                }
                this.updateSingleSeq(subawardCode, currentSequenceNumber, ARCHIVED);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getKewStatus(String documentNumber) {
        if (documentNumber == null) return null;
        if (documentNumber.trim().equals("")) {
            return null;
        }
        Connection connection = this.connectionDaoService.getRiceConnection();
        try (PreparedStatement statement = PreparedStatementUtils.setString(1, documentNumber, connection.prepareStatement(KEW_DOC_STATUS));
             ResultSet result = statement.executeQuery();){
            if (!result.next()) return null;
            String string = result.getString(1);
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }
}

