/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.lookupable.MyColumns;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GroupRuleResponsibility;
import org.kuali.rice.kew.rule.PersonRuleResponsibility;
import org.kuali.rice.kew.rule.RoleRuleResponsibility;
import org.kuali.rice.kew.rule.RuleExpressionDef;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.Boolean01Converter;
import org.kuali.rice.krad.data.provider.annotation.SerializationContext;
import org.kuali.rice.krad.data.provider.annotation.Serialized;

@Entity
@Table(name="KREW_RULE_T")
public class RuleBaseValues
extends PersistableBusinessObjectBase
implements RuleContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    private static final long serialVersionUID = 6137765574728530156L;
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @PortableSequenceGenerator(name="KREW_RTE_TMPL_S")
    @Column(name="RULE_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="RULE_TMPL_ID")
    private String ruleTemplateId;
    @Column(name="PREV_VER_RULE_ID")
    private String previousRuleId;
    @Column(name="ACTV_IND")
    @Convert(converter=Boolean01Converter.class)
    private boolean active = true;
    @Column(name="RULE_BASE_VAL_DESC")
    private String description;
    @Column(name="DOC_TYP_NM")
    private String docTypeName;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="FRM_DT")
    private Timestamp fromDateValue;
    @Column(name="TO_DT")
    private Timestamp toDateValue;
    @Column(name="DACTVN_DT")
    private Timestamp deactivationDate;
    @Column(name="CUR_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean currentInd = Boolean.TRUE;
    @Column(name="RULE_VER_NBR")
    private Integer versionNbr = 0;
    @Column(name="FRC_ACTN")
    @Convert(converter=Boolean01Converter.class)
    private boolean forceAction;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="RULE_ID", referencedColumnName="RULE_ID")
    private List<RuleResponsibilityBo> ruleResponsibilities;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="RULE_ID", referencedColumnName="RULE_ID")
    private List<RuleExtensionBo> ruleExtensions;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_TMPL_ID", insertable=false, updatable=false)
    private RuleTemplateBo ruleTemplate;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="RULE_EXPR_ID")
    private RuleExpressionDef ruleExpressionDef;
    @Transient
    private RuleBaseValues previousVersion;
    @Column(name="ACTVN_DT")
    private Timestamp activationDate;
    @Column(name="DLGN_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean delegateRule = Boolean.FALSE;
    @Column(name="TMPL_RULE_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean templateRuleInd = Boolean.FALSE;
    @Transient
    private String returnUrl;
    @Transient
    private String destinationUrl;
    @Transient
    private MyColumns myColumns;
    @Transient
    @Serialized(enabled=true, forContexts={SerializationContext.MAINTENANCE})
    private List<PersonRuleResponsibility> personResponsibilities = new ArrayList<PersonRuleResponsibility>();
    @Transient
    @Serialized(enabled=true, forContexts={SerializationContext.MAINTENANCE})
    private List<GroupRuleResponsibility> groupResponsibilities = new ArrayList<GroupRuleResponsibility>();
    @Transient
    @Serialized(enabled=true, forContexts={SerializationContext.MAINTENANCE})
    private List<RoleRuleResponsibility> roleResponsibilities = new ArrayList<RoleRuleResponsibility>();
    @Transient
    private Map<String, String> fieldValues;
    @Transient
    private String groupReviewerName;
    @Transient
    private String groupReviewerNamespace;
    @Transient
    private String personReviewer;
    @Transient
    private String personReviewerType;

    public RuleBaseValues() {
        this.ruleResponsibilities = new ArrayList<RuleResponsibilityBo>();
        this.ruleExtensions = new ArrayList<RuleExtensionBo>();
        this.fieldValues = new HashMap<String, String>();
    }

    public RuleExpressionDef getRuleExpressionDef() {
        return this._persistence_get_ruleExpressionDef();
    }

    public void setRuleExpressionDef(RuleExpressionDef ruleExpressionDef) {
        this._persistence_set_ruleExpressionDef(ruleExpressionDef);
    }

    public String getRuleTemplateName() {
        if (this._persistence_get_ruleTemplate() != null) {
            return this._persistence_get_ruleTemplate().getName();
        }
        return null;
    }

    public RuleBaseValues getPreviousVersion() {
        if (this.previousVersion == null && this._persistence_get_previousRuleId() != null) {
            RuleServiceInternal ruleService = (RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal");
            return ruleService.findRuleBaseValuesById(this._persistence_get_previousRuleId());
        }
        return this.previousVersion;
    }

    public void setPreviousVersion(RuleBaseValues previousVersion) {
        this.previousVersion = previousVersion;
    }

    public RuleResponsibilityBo getResponsibility(int index) {
        while (this.getRuleResponsibilities().size() <= index) {
            RuleResponsibilityBo ruleResponsibility = new RuleResponsibilityBo();
            ruleResponsibility.setRuleBaseValues(this);
            this.getRuleResponsibilities().add(ruleResponsibility);
        }
        return this.getRuleResponsibilities().get(index);
    }

    public RuleExtensionBo getRuleExtension(int index) {
        while (this.getRuleExtensions().size() <= index) {
            this.getRuleExtensions().add(new RuleExtensionBo());
        }
        return this.getRuleExtensions().get(index);
    }

    public RuleExtensionValue getRuleExtensionValue(String key) {
        for (RuleExtensionBo ruleExtension : this.getRuleExtensions()) {
            for (RuleExtensionValue ruleExtensionValue : ruleExtension.getExtensionValues()) {
                if (!ruleExtensionValue.getKey().equals(key)) continue;
                return ruleExtensionValue;
            }
        }
        return null;
    }

    public RuleExtensionValue getRuleExtensionValue(String ruleTemplateAttributeId, String key) {
        for (RuleExtensionBo ruleExtension : this.getRuleExtensions()) {
            if (!ruleExtension.getRuleTemplateAttributeId().equals(ruleTemplateAttributeId)) continue;
            for (RuleExtensionValue ruleExtensionValue : ruleExtension.getExtensionValues()) {
                if (!ruleExtensionValue.getKey().equals(key)) continue;
                return ruleExtensionValue;
            }
        }
        return null;
    }

    public String getPreviousRuleId() {
        return this._persistence_get_previousRuleId();
    }

    public void setPreviousRuleId(String previousVersion) {
        this._persistence_set_previousRuleId(previousVersion);
    }

    public void addRuleResponsibility(RuleResponsibilityBo ruleResponsibility) {
        this.addRuleResponsibility(ruleResponsibility, new Integer(this.getRuleResponsibilities().size()));
    }

    public void addRuleResponsibility(RuleResponsibilityBo ruleResponsibility, Integer counter) {
        boolean alreadyAdded = false;
        int location = 0;
        if (counter != null) {
            for (RuleResponsibilityBo ruleResponsibilityRow : this.getRuleResponsibilities()) {
                if (counter == location) {
                    ruleResponsibilityRow.setPriority(ruleResponsibility.getPriority());
                    ruleResponsibilityRow.setActionRequestedCd(ruleResponsibility.getActionRequestedCd());
                    ruleResponsibilityRow.setVersionNumber(ruleResponsibility.getVersionNumber());
                    ruleResponsibilityRow.setRuleBaseValuesId(ruleResponsibility.getRuleBaseValuesId());
                    ruleResponsibilityRow.setRuleResponsibilityName(ruleResponsibility.getRuleResponsibilityName());
                    ruleResponsibilityRow.setRuleResponsibilityType(ruleResponsibility.getRuleResponsibilityType());
                    ruleResponsibilityRow.setApprovePolicy(ruleResponsibility.getApprovePolicy());
                    alreadyAdded = true;
                }
                ++location;
            }
        }
        if (!alreadyAdded) {
            this.getRuleResponsibilities().add(ruleResponsibility);
        }
    }

    public RuleTemplateBo getRuleTemplate() {
        return this._persistence_get_ruleTemplate();
    }

    public void setRuleTemplate(RuleTemplateBo ruleTemplate) {
        this._persistence_set_ruleTemplate(ruleTemplate);
    }

    public String getRuleTemplateId() {
        return this._persistence_get_ruleTemplateId();
    }

    public void setRuleTemplateId(String ruleTemplateId) {
        this._persistence_set_ruleTemplateId(ruleTemplateId);
    }

    public DocumentType getDocumentType() {
        return KEWServiceLocator.getDocumentTypeService().findByName(this.getDocTypeName());
    }

    public String getDocTypeName() {
        return this._persistence_get_docTypeName();
    }

    public void setDocTypeName(String docTypeName) {
        this._persistence_set_docTypeName(docTypeName);
    }

    public List<RuleExtensionBo> getRuleExtensions() {
        return this._persistence_get_ruleExtensions();
    }

    public Map<String, String> getRuleExtensionMap() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (RuleExtensionBo ext : this.getRuleExtensions()) {
            for (RuleExtensionValue value : ext.getExtensionValues()) {
                extensions.put(value.getKey(), value.getValue());
            }
        }
        return extensions;
    }

    public void setRuleExtensions(List<RuleExtensionBo> ruleExtensions) {
        this._persistence_set_ruleExtensions(ruleExtensions);
    }

    public List<RuleResponsibilityBo> getRuleResponsibilities() {
        return this._persistence_get_ruleResponsibilities();
    }

    public void setRuleResponsibilities(List<RuleResponsibilityBo> ruleResponsibilities) {
        this._persistence_set_ruleResponsibilities(ruleResponsibilities);
    }

    public RuleResponsibilityBo getResponsibility(Long ruleResponsibilityKey) {
        for (RuleResponsibilityBo responsibility : this.getRuleResponsibilities()) {
            if (responsibility.getId() == null || !responsibility.getId().equals(ruleResponsibilityKey)) continue;
            return responsibility;
        }
        return null;
    }

    public void removeResponsibility(int index) {
        this.getRuleResponsibilities().remove(index);
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getActiveIndDisplay() {
        return CodeTranslator.getActiveIndicatorLabel((Boolean)this.isActive());
    }

    public Boolean getCurrentInd() {
        return this._persistence_get_currentInd();
    }

    public void setCurrentInd(Boolean currentInd) {
        this._persistence_set_currentInd(currentInd);
    }

    public Timestamp getFromDateValue() {
        return this._persistence_get_fromDateValue();
    }

    public DateTime getFromDate() {
        if (this._persistence_get_fromDateValue() == null) {
            return null;
        }
        return new DateTime(this._persistence_get_fromDateValue().getTime());
    }

    public void setFromDateValue(Timestamp fromDateValue) {
        this._persistence_set_fromDateValue(fromDateValue);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public Timestamp getToDateValue() {
        return this._persistence_get_toDateValue();
    }

    public DateTime getToDate() {
        if (this._persistence_get_toDateValue() == null) {
            return null;
        }
        return new DateTime(this._persistence_get_toDateValue().getTime());
    }

    public void setToDateValue(Timestamp toDateValue) {
        this._persistence_set_toDateValue(toDateValue);
    }

    public Integer getVersionNbr() {
        return this._persistence_get_versionNbr();
    }

    public void setVersionNbr(Integer versionNbr) {
        this._persistence_set_versionNbr(versionNbr);
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getFromDateString() {
        if (this._persistence_get_fromDateValue() != null) {
            return RiceConstants.getDefaultDateFormat().format(this._persistence_get_fromDateValue());
        }
        return null;
    }

    public String getToDateString() {
        if (this._persistence_get_toDateValue() != null) {
            return RiceConstants.getDefaultDateFormat().format(this._persistence_get_toDateValue());
        }
        return null;
    }

    public boolean isForceAction() {
        return this._persistence_get_forceAction();
    }

    public void setForceAction(boolean forceAction) {
        this._persistence_set_forceAction(forceAction);
    }

    public boolean isActive(Date date) {
        boolean isAfterFromDate = this.getFromDateValue() == null || date.after(this.getFromDateValue());
        boolean isBeforeToDate = this.getToDateValue() == null || date.before(this.getToDateValue());
        return this.isActive() && isAfterFromDate && isBeforeToDate;
    }

    public boolean isMatch(DocumentContent docContent) {
        for (RuleTemplateAttributeBo ruleTemplateAttribute : this.getRuleTemplate().getActiveRuleTemplateAttributes()) {
            if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
            WorkflowRuleAttribute routingAttribute = ruleTemplateAttribute.getWorkflowAttribute();
            RuleAttribute ruleAttribute = ruleTemplateAttribute.getRuleAttribute();
            if (ruleAttribute.getType().equals("RuleXmlAttribute")) {
                ((GenericXMLRuleAttribute)routingAttribute).setExtensionDefinition(RuleAttribute.to(ruleAttribute));
            }
            String className = ruleAttribute.getResourceDescriptor();
            ArrayList<RuleExtension> editedRuleExtensions = new ArrayList<RuleExtension>();
            for (RuleExtensionBo extension : this.getRuleExtensions()) {
                if (!extension.getRuleTemplateAttribute().getRuleAttribute().getResourceDescriptor().equals(className)) continue;
                editedRuleExtensions.add(RuleExtensionBo.to(extension));
            }
            if (routingAttribute.isMatch(docContent, editedRuleExtensions)) continue;
            return false;
        }
        return true;
    }

    public RuleResponsibilityBo findResponsibility(String roleName) {
        for (RuleResponsibilityBo resp : this.getRuleResponsibilities()) {
            if (!"R".equals(resp.getRuleResponsibilityType()) || !roleName.equals(resp.getRuleResponsibilityName())) continue;
            return resp;
        }
        return null;
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public Boolean getDelegateRule() {
        return this._persistence_get_delegateRule();
    }

    public void setDelegateRule(Boolean isDelegateRule) {
        this._persistence_set_delegateRule(isDelegateRule);
    }

    public Timestamp getActivationDate() {
        return this._persistence_get_activationDate();
    }

    public void setActivationDate(Timestamp activationDate) {
        this._persistence_set_activationDate(activationDate);
    }

    public MyColumns getMyColumns() {
        return this.myColumns;
    }

    public void setMyColumns(MyColumns additionalColumns) {
        this.myColumns = additionalColumns;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    public void setDestinationUrl(String destinationUrl) {
        this.destinationUrl = destinationUrl;
    }

    public Timestamp getDeactivationDate() {
        return this._persistence_get_deactivationDate();
    }

    public void setDeactivationDate(Timestamp deactivationDate) {
        this._persistence_set_deactivationDate(deactivationDate);
    }

    public Boolean getTemplateRuleInd() {
        return this._persistence_get_templateRuleInd();
    }

    public void setTemplateRuleInd(Boolean templateRuleInd) {
        this._persistence_set_templateRuleInd(templateRuleInd);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public List<PersonRuleResponsibility> getPersonResponsibilities() {
        return this.personResponsibilities;
    }

    public void setPersonResponsibilities(List<PersonRuleResponsibility> personResponsibilities) {
        this.personResponsibilities = personResponsibilities;
    }

    public List<GroupRuleResponsibility> getGroupResponsibilities() {
        return this.groupResponsibilities;
    }

    public void setGroupResponsibilities(List<GroupRuleResponsibility> groupResponsibilities) {
        this.groupResponsibilities = groupResponsibilities;
    }

    public List<RoleRuleResponsibility> getRoleResponsibilities() {
        return this.roleResponsibilities;
    }

    public void setRoleResponsibilities(List<RoleRuleResponsibility> roleResponsibilities) {
        this.roleResponsibilities = roleResponsibilities;
    }

    public Map<String, String> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(Map<String, String> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public String getGroupReviewerName() {
        return this.groupReviewerName;
    }

    public String getGroupReviewerNamespace() {
        return this.groupReviewerNamespace;
    }

    public String getPersonReviewer() {
        return this.personReviewer;
    }

    public void setGroupReviewerName(String groupReviewerName) {
        this.groupReviewerName = groupReviewerName;
    }

    public void setGroupReviewerNamespace(String groupReviewerNamespace) {
        this.groupReviewerNamespace = groupReviewerNamespace;
    }

    public void setPersonReviewer(String personReviewer) {
        this.personReviewer = personReviewer;
    }

    public GroupBo getGroupBo() {
        GroupBo groupBo = null;
        if (StringUtils.isNotBlank((String)this.getGroupReviewerName()) && groupBo == null) {
            groupBo = GroupBo.from((Group)KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(this.getGroupReviewerNamespace(), this.getGroupReviewerName()));
        }
        return groupBo;
    }

    public PersonImpl getPersonImpl() {
        return new PersonImpl();
    }

    public String getPersonReviewerType() {
        return this.personReviewerType;
    }

    public void setPersonReviewerType(String personReviewerType) {
        this.personReviewerType = personReviewerType;
    }

    public static Rule to(RuleBaseValues bo) {
        if (bo == null) {
            return null;
        }
        return Rule.Builder.create((RuleContract)bo).build();
    }

    public void refresh() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RuleBaseValues();
    }

    public Object _persistence_get(String string) {
        if (string == "deactivationDate") {
            return this.deactivationDate;
        }
        if (string == "ruleTemplate") {
            return this.ruleTemplate;
        }
        if (string == "toDateValue") {
            return this.toDateValue;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "ruleTemplateId") {
            return this.ruleTemplateId;
        }
        if (string == "ruleResponsibilities") {
            return this.ruleResponsibilities;
        }
        if (string == "fromDateValue") {
            return this.fromDateValue;
        }
        if (string == "versionNbr") {
            return this.versionNbr;
        }
        if (string == "forceAction") {
            return this.forceAction;
        }
        if (string == "docTypeName") {
            return this.docTypeName;
        }
        if (string == "currentInd") {
            return this.currentInd;
        }
        if (string == "templateRuleInd") {
            return this.templateRuleInd;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "ruleExpressionDef") {
            return this.ruleExpressionDef;
        }
        if (string == "delegateRule") {
            return this.delegateRule;
        }
        if (string == "previousRuleId") {
            return this.previousRuleId;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "ruleExtensions") {
            return this.ruleExtensions;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "activationDate") {
            return this.activationDate;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "deactivationDate") {
            this.deactivationDate = (Timestamp)object;
            return;
        }
        if (string == "ruleTemplate") {
            this.ruleTemplate = (RuleTemplateBo)((Object)object);
            return;
        }
        if (string == "toDateValue") {
            this.toDateValue = (Timestamp)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "ruleTemplateId") {
            this.ruleTemplateId = (String)object;
            return;
        }
        if (string == "ruleResponsibilities") {
            this.ruleResponsibilities = (List)object;
            return;
        }
        if (string == "fromDateValue") {
            this.fromDateValue = (Timestamp)object;
            return;
        }
        if (string == "versionNbr") {
            this.versionNbr = (Integer)object;
            return;
        }
        if (string == "forceAction") {
            this.forceAction = (Boolean)object;
            return;
        }
        if (string == "docTypeName") {
            this.docTypeName = (String)object;
            return;
        }
        if (string == "currentInd") {
            this.currentInd = (Boolean)object;
            return;
        }
        if (string == "templateRuleInd") {
            this.templateRuleInd = (Boolean)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "ruleExpressionDef") {
            this.ruleExpressionDef = (RuleExpressionDef)((Object)object);
            return;
        }
        if (string == "delegateRule") {
            this.delegateRule = (Boolean)object;
            return;
        }
        if (string == "previousRuleId") {
            this.previousRuleId = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "ruleExtensions") {
            this.ruleExtensions = (List)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "activationDate") {
            this.activationDate = (Timestamp)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Timestamp _persistence_get_deactivationDate() {
        this._persistence_checkFetched("deactivationDate");
        return this.deactivationDate;
    }

    public void _persistence_set_deactivationDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("deactivationDate");
        this.deactivationDate = timestamp;
    }

    public RuleTemplateBo _persistence_get_ruleTemplate() {
        this._persistence_checkFetched("ruleTemplate");
        return this.ruleTemplate;
    }

    public void _persistence_set_ruleTemplate(RuleTemplateBo ruleTemplateBo) {
        this._persistence_checkFetchedForSet("ruleTemplate");
        this.ruleTemplate = ruleTemplateBo;
    }

    public Timestamp _persistence_get_toDateValue() {
        this._persistence_checkFetched("toDateValue");
        return this.toDateValue;
    }

    public void _persistence_set_toDateValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("toDateValue");
        this.toDateValue = timestamp;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public String _persistence_get_ruleTemplateId() {
        this._persistence_checkFetched("ruleTemplateId");
        return this.ruleTemplateId;
    }

    public void _persistence_set_ruleTemplateId(String string) {
        this._persistence_checkFetchedForSet("ruleTemplateId");
        this.ruleTemplateId = string;
    }

    public List _persistence_get_ruleResponsibilities() {
        this._persistence_checkFetched("ruleResponsibilities");
        return this.ruleResponsibilities;
    }

    public void _persistence_set_ruleResponsibilities(List list) {
        this._persistence_checkFetchedForSet("ruleResponsibilities");
        this.ruleResponsibilities = list;
    }

    public Timestamp _persistence_get_fromDateValue() {
        this._persistence_checkFetched("fromDateValue");
        return this.fromDateValue;
    }

    public void _persistence_set_fromDateValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("fromDateValue");
        this.fromDateValue = timestamp;
    }

    public Integer _persistence_get_versionNbr() {
        this._persistence_checkFetched("versionNbr");
        return this.versionNbr;
    }

    public void _persistence_set_versionNbr(Integer n) {
        this._persistence_checkFetchedForSet("versionNbr");
        this.versionNbr = n;
    }

    public boolean _persistence_get_forceAction() {
        this._persistence_checkFetched("forceAction");
        return this.forceAction;
    }

    public void _persistence_set_forceAction(boolean bl) {
        this._persistence_checkFetchedForSet("forceAction");
        this.forceAction = bl;
    }

    public String _persistence_get_docTypeName() {
        this._persistence_checkFetched("docTypeName");
        return this.docTypeName;
    }

    public void _persistence_set_docTypeName(String string) {
        this._persistence_checkFetchedForSet("docTypeName");
        this.docTypeName = string;
    }

    public Boolean _persistence_get_currentInd() {
        this._persistence_checkFetched("currentInd");
        return this.currentInd;
    }

    public void _persistence_set_currentInd(Boolean bl) {
        this._persistence_checkFetchedForSet("currentInd");
        this.currentInd = bl;
    }

    public Boolean _persistence_get_templateRuleInd() {
        this._persistence_checkFetched("templateRuleInd");
        return this.templateRuleInd;
    }

    public void _persistence_set_templateRuleInd(Boolean bl) {
        this._persistence_checkFetchedForSet("templateRuleInd");
        this.templateRuleInd = bl;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public RuleExpressionDef _persistence_get_ruleExpressionDef() {
        this._persistence_checkFetched("ruleExpressionDef");
        return this.ruleExpressionDef;
    }

    public void _persistence_set_ruleExpressionDef(RuleExpressionDef ruleExpressionDef) {
        this._persistence_checkFetchedForSet("ruleExpressionDef");
        this.ruleExpressionDef = ruleExpressionDef;
    }

    public Boolean _persistence_get_delegateRule() {
        this._persistence_checkFetched("delegateRule");
        return this.delegateRule;
    }

    public void _persistence_set_delegateRule(Boolean bl) {
        this._persistence_checkFetchedForSet("delegateRule");
        this.delegateRule = bl;
    }

    public String _persistence_get_previousRuleId() {
        this._persistence_checkFetched("previousRuleId");
        return this.previousRuleId;
    }

    public void _persistence_set_previousRuleId(String string) {
        this._persistence_checkFetchedForSet("previousRuleId");
        this.previousRuleId = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this.documentId = string;
    }

    public List _persistence_get_ruleExtensions() {
        this._persistence_checkFetched("ruleExtensions");
        return this.ruleExtensions;
    }

    public void _persistence_set_ruleExtensions(List list) {
        this._persistence_checkFetchedForSet("ruleExtensions");
        this.ruleExtensions = list;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this.id = string;
    }

    public Timestamp _persistence_get_activationDate() {
        this._persistence_checkFetched("activationDate");
        return this.activationDate;
    }

    public void _persistence_set_activationDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("activationDate");
        this.activationDate = timestamp;
    }
}

