/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.period;

import java.sql.Date;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleBase;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.krad.util.AuditError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetPeriodAuditRule")
public class BudgetPeriodAuditRule
extends BudgetAuditRuleBase {
    private static final String BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY = "budgetPeriodProjectDateAuditErrors";
    private static final String BUDGET_PERIOD_DATE_AUDIT_WARNING_KEY = "budgetPeriodProjectDateAuditWarnings";
    @Autowired
    @Qualifier(value="errorReporter")
    private ErrorReporter errorReporter;

    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditEvent event) {
        if (event == null || event.getBudget() == null) {
            throw new NullPointerException("the budget is null");
        }
        return this.validatePeriodDates(event.getBudget());
    }

    private boolean validatePeriodDates(Budget budget) {
        boolean retval = true;
        BudgetParent budgetParent = budget.getBudgetParent().getDocument().getBudgetParent();
        Date projectStartDate = budgetParent.getRequestedStartDateInitial();
        Date projectEndDate = budgetParent.getRequestedEndDateInitial();
        int i = 0;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            Date budgetPeriodStartDate = budgetPeriod.getStartDate();
            Date budgetPeriodEndDate = budgetPeriod.getEndDate();
            if (budgetPeriodStartDate != null && budgetPeriodStartDate.before(projectStartDate)) {
                retval = false;
                this.addBudgetPeriodDateAuditError(new AuditError("document.budgetPeriods[" + i + "].startDate", "error.periodStartDate.before.projectStartDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            if (budgetPeriodEndDate != null && budgetPeriodEndDate.after(projectEndDate)) {
                retval = false;
                this.addBudgetPeriodDateAuditError(new AuditError("document.budgetPeriods[" + i + "].endDate", "error.periodEndDate.after.projectEndDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            if (i == 0 && budgetPeriodStartDate != null && budgetPeriodStartDate.after(projectStartDate)) {
                this.addBudgetPeriodDateAuditWarning(new AuditError("document.budgetPeriods[" + i + "].startDate", "warning.budgetStartDate.after.projectStartDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            if (i == budget.getBudgetPeriods().size() - 1 && budgetPeriodEndDate != null && budgetPeriodEndDate.before(projectEndDate)) {
                this.addBudgetPeriodDateAuditWarning(new AuditError("document.budgetPeriods[" + i + "].endDate", "warning.budgetEndDate.before.projectEndDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            ++i;
        }
        return retval;
    }

    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditRuleEvent event) {
        return this.verifyBudgetPeriods(event.getBudget());
    }

    protected boolean verifyBudgetPeriods(Budget budget) {
        boolean retval = true;
        BudgetParent budgetParent = budget.getBudgetParent().getDocument().getBudgetParent();
        Date projectStartDate = budgetParent.getRequestedStartDateInitial();
        Date projectEndDate = budgetParent.getRequestedEndDateInitial();
        int periodIndex = 0;
        BudgetConstants.BudgetAuditRules budgetPeriodAndTotalRule = BudgetConstants.BudgetAuditRules.PERIODS_AND_TOTALS;
        List<AuditError> auditWarnings = this.getAuditErrors(budgetPeriodAndTotalRule, false);
        List<AuditError> auditErrors = this.getAuditErrors(budgetPeriodAndTotalRule, true);
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            Date budgetPeriodStartDate = budgetPeriod.getStartDate();
            Date budgetPeriodEndDate = budgetPeriod.getEndDate();
            if (budgetPeriodStartDate != null && budgetPeriodStartDate.before(projectStartDate)) {
                auditErrors.add(new AuditError(budgetPeriodAndTotalRule.getPageId(), "error.periodStartDate.before.projectStartDate", budgetPeriodAndTotalRule.getPageId(), new String[]{budgetPeriod.getBudgetPeriod().toString()}));
                retval = false;
            }
            if (budgetPeriodEndDate != null && budgetPeriodEndDate.after(projectEndDate)) {
                auditErrors.add(new AuditError(budgetPeriodAndTotalRule.getPageId(), "error.periodEndDate.after.projectEndDate", budgetPeriodAndTotalRule.getPageId(), new String[]{budgetPeriod.getBudgetPeriod().toString()}));
                retval = false;
            }
            if (periodIndex == 0 && budgetPeriodStartDate != null && budgetPeriodStartDate.after(projectStartDate)) {
                auditWarnings.add(new AuditError(budgetPeriodAndTotalRule.getPageId(), "warning.budgetStartDate.after.projectStartDate", budgetPeriodAndTotalRule.getPageId(), new String[]{budgetPeriod.getBudgetPeriod().toString()}));
                retval = false;
            }
            if (periodIndex == budget.getBudgetPeriods().size() - 1 && budgetPeriodEndDate != null && budgetPeriodEndDate.before(projectEndDate)) {
                auditWarnings.add(new AuditError(budgetPeriodAndTotalRule.getPageId(), "warning.budgetEndDate.before.projectEndDate", budgetPeriodAndTotalRule.getPageId(), new String[]{budgetPeriod.getBudgetPeriod().toString()}));
                retval = false;
            }
            ++periodIndex;
        }
        return retval;
    }

    private void addBudgetPeriodDateAuditWarning(AuditError warning) {
        assert (warning != null) : "the warning is null";
        this.errorReporter.reportAuditError(warning, BUDGET_PERIOD_DATE_AUDIT_WARNING_KEY, "Budget Period And Totals Information", "Warnings");
    }

    private void addBudgetPeriodDateAuditError(AuditError error) {
        assert (error != null) : "the error is null";
        this.errorReporter.reportAuditError(error, BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY, "Budget Period And Totals Information", "Error");
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

