/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.subaward.api;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.subaward.dto.AwardHierarchyDto;
import org.kuali.coeus.subaward.dto.AwardSummaryDto;
import org.kuali.coeus.subaward.dto.SubawardDto;
import org.kuali.coeus.subaward.dto.SubawardFundingSourceDto;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardReports;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api"})
@Controller(value="subawardDocumentController")
public class SubawardDocumentController
extends RestController
implements InitializingBean {
    private static final String SUB_AWARD_ID = "subAwardId";
    private static final String SUB_AWARD_CODE = "subAwardCode";
    private static final String SUB_AWARD_SEQUENCE_STATUS = "subAwardSequenceStatus";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String AWARD_SEQUENCE_STATUS = "awardSequenceStatus";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String CONTACT_TYPE = "contactType";
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="subAwardService")
    private SubAwardService subawardService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;
    @Autowired
    @Qualifier(value="awardHierarchyService")
    private AwardHierarchyService awardHierarchyService;
    private List<String> subawardDtoProperties;

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/subaward-documents/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<SubawardDto> getSubawards(@RequestParam(value="subawardCode", required=false) String subawardCode, @RequestParam(value="subawardId", required=false) String subawardId, @RequestParam(value="activeVersionOnly", required=false) boolean activeVersionOnly, @RequestParam(value="includeFundingSourceDetails", required=false) boolean includeFundingSourceDetails, @RequestParam(value="subAwardFundingSourceId", required=false) Integer subAwardFundingSourceId) {
        this.assertUserHasReadAccess();
        if (StringUtils.isBlank((CharSequence)subawardCode) && StringUtils.isBlank((CharSequence)subawardId)) {
            throw new NotImplementedException("GET all Subawards has not been implemented.");
        }
        if (StringUtils.isNotBlank((CharSequence)subawardCode) && StringUtils.isNotBlank((CharSequence)subawardId)) {
            throw new UnprocessableEntityException("Specify either subawardCode or subawardId.");
        }
        if (StringUtils.isNotBlank((CharSequence)subawardId)) {
            return Collections.singletonList(this.commonApiService.convertObject(this.businessObjectService.findByPrimaryKey(SubAward.class, Collections.singletonMap(SUB_AWARD_ID, subawardId)), SubawardDto.class));
        }
        if (StringUtils.isNotBlank((CharSequence)subawardCode)) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put(SUB_AWARD_CODE, subawardCode);
            if (activeVersionOnly) {
                criteria.put(SUB_AWARD_SEQUENCE_STATUS, VersionStatus.ACTIVE.toString());
            }
            return this.businessObjectService.findMatching(SubAward.class, criteria).stream().peek(subaward -> this.fetchContactType(subaward.getSubAwardContactsList())).map(subaward -> this.commonApiService.convertObject(subaward, SubawardDto.class)).peek(subawardDto -> {
                if (subAwardFundingSourceId != null) {
                    subawardDto.setSubAwardFundingSourceList(this.filterFundingSources(subawardDto.getSubAwardFundingSourceList(), subAwardFundingSourceId));
                }
            }).peek(subawardDto -> {
                if (includeFundingSourceDetails) {
                    subawardDto.getSubAwardFundingSourceList().forEach(this::setFundingSourceDetails);
                }
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/subaward-documents/{documentNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public SubawardDto getSubaward(@PathVariable String documentNumber, @RequestParam(value="includeFundingSourceDetails", required=false) boolean includeFundingSourceDetails, @RequestParam(value="subAwardFundingSourceId", required=false) Integer subAwardFundingSourceId) {
        this.assertUserHasReadAccess();
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            throw new UnprocessableEntityException("documentNumber cannot be blank");
        }
        try {
            SubAwardDocument subawardDocument = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            if (subawardDocument != null) {
                this.fetchContactType(subawardDocument.getSubAward().getSubAwardContactsList());
                SubawardDto subawardDto = this.commonApiService.convertObject(subawardDocument.getSubAward(), SubawardDto.class);
                if (subAwardFundingSourceId != null) {
                    subawardDto.setSubAwardFundingSourceList(this.filterFundingSources(subawardDto.getSubAwardFundingSourceList(), subAwardFundingSourceId));
                }
                if (includeFundingSourceDetails) {
                    subawardDto.getSubAwardFundingSourceList().forEach(this::setFundingSourceDetails);
                }
                return subawardDto;
            }
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        throw new UnprocessableEntityException("SubAward with documentNumber " + documentNumber + " not found.");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/v1/subaward-documents/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String createSubawardDocument(@RequestBody SubawardDto subawardDto, @RequestParam(value="route", required=false) boolean route) {
        this.assertUserHasWriteAccess();
        RestAuditLogger auditLogger = this.getRestAuditLoggerFactory().getNewAuditLogger(SubawardDto.class, this.subawardDtoProperties);
        this.getCommonApiService().clearErrors();
        SubAward subaward = this.getCommonApiService().convertObject(subawardDto, SubAward.class);
        subaward.setSubAwardCode(this.getSubawardService().getNextSubAwardCode());
        subaward.setSequenceNumber(1);
        subaward.setSubAwardSequenceStatus(VersionStatus.PENDING.name());
        subaward.setNewVersion(false);
        subaward.setSubAwardContactsList(subawardDto.getSubAwardContactsList().stream().map(contactDto -> {
            SubAwardContact subawardContact = this.commonApiService.convertObject(contactDto, SubAwardContact.class);
            subawardContact.setSubAwardCode(subaward.getSubAwardCode());
            subawardContact.setSequenceNumber(subaward.getSequenceNumber());
            this.getCommonApiService().validatePerson(null, subawardContact.getRolodexId());
            return subawardContact;
        }).collect(Collectors.toList()));
        if (subawardDto.getSubAwardCustomDataList() != null) {
            subaward.setSubAwardCustomDataList(subawardDto.getSubAwardCustomDataList().stream().map(customDataDto -> {
                SubAwardCustomData subAwardCustomData = this.commonApiService.convertObject(customDataDto, SubAwardCustomData.class);
                subAwardCustomData.setSubAwardCode(subaward.getSubAwardCode());
                subAwardCustomData.setSequenceNumber(subaward.getSequenceNumber());
                return subAwardCustomData;
            }).collect(Collectors.toList()));
        }
        if (subawardDto.getSubAwardAmountInfoList() != null) {
            subaward.setSubAwardAmountInfoList(subawardDto.getSubAwardAmountInfoList().stream().map(subAwardAmountInfoDto -> {
                SubAwardAmountInfo subAwardAmountInfo = this.commonApiService.convertObject(subAwardAmountInfoDto, SubAwardAmountInfo.class);
                subAwardAmountInfo.setSubAwardCode(subaward.getSubAwardCode());
                subAwardAmountInfo.setSequenceNumber(subaward.getSequenceNumber());
                return subAwardAmountInfo;
            }).collect(Collectors.toList()));
        }
        if (subawardDto.getSubAwardReportList() != null) {
            subaward.setSubAwardReportList(subawardDto.getSubAwardReportList().stream().map(subawardReportsDto -> {
                SubAwardReports subawardReport = this.commonApiService.convertObject(subawardReportsDto, SubAwardReports.class);
                subawardReport.setSubAwardCode(subaward.getSubAwardCode());
                subawardReport.setSequenceNumber(subaward.getSequenceNumber());
                return subawardReport;
            }).collect(Collectors.toList()));
        }
        try {
            SubAwardDocument subawardDocument = (SubAwardDocument)this.getDocumentService().getNewDocument(SubAwardDocument.class);
            subawardDocument.getDocumentHeader().setDocumentDescription(subawardDto.getDocumentDescription());
            subawardDocument.setSubAward(subaward);
            subaward.refreshNonUpdateableReferences();
            this.getCommonApiService().validatePerson(subaward.getRequisitionerId(), null);
            if (!new SubAwardDocumentRule().processAddSubAwardBusinessRules(subaward)) {
                throw new UnprocessableEntityException(GlobalVariables.getMessageMap().getErrorMessages().toString());
            }
            this.commonApiService.saveDocument((Document)subawardDocument);
            if (route) {
                this.getCommonApiService().routeDocument((Document)subawardDocument);
            }
            if (subawardDto.getSubAwardAmountReleasedList() != null) {
                subawardDto.getSubAwardAmountReleasedList().forEach(subawardAmountReleasedDto -> {
                    SubAwardAmountReleased subAwardAmountReleased = this.commonApiService.convertObject(subawardAmountReleasedDto, SubAwardAmountReleased.class);
                    subAwardAmountReleased.setSubAwardCode(subaward.getSubAwardCode());
                    subAwardAmountReleased.setSubAward(subaward);
                    subAwardAmountReleased.setSequenceNumber(subaward.getSequenceNumber());
                    this.businessObjectService.save((PersistableBusinessObject)subAwardAmountReleased);
                });
            }
            auditLogger.addNewItem(subawardDto);
            auditLogger.saveAuditLog();
            return subawardDocument.getDocumentNumber();
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/v1/subaward-documents/{documentNumber}"}, params={"route"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void routeSubawardDocument(@PathVariable String documentNumber) {
        this.assertUserHasWriteAccess();
        this.getCommonApiService().clearErrors();
        try {
            SubAwardDocument subawardDocument = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.getCommonApiService().routeDocument((Document)subawardDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/v1/subaward-documents/{documentNumber}"}, params={"version"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String versionSubawardDocument(@RequestBody SubawardDto subawardDto, @PathVariable String documentNumber) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        SubAwardDocument subawardDocument = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        if (subawardDocument == null) {
            throw new UnprocessableEntityException("SubAward with documentNumber " + documentNumber + " not found.");
        }
        if (this.getVersionHistoryService().findPendingVersion(SubAward.class, subawardDocument.getSubAward().getSubAwardCode()) != null) {
            throw new UnprocessableEntityException("A PENDING document already exists for this subawardId.");
        }
        return this.versionSubawardDocument(subawardDto, subawardDocument);
    }

    public String versionSubawardDocument(SubawardDto subawardDto, SubAwardDocument subawardDocumentToVersion) {
        try {
            SubAwardDocument newSubAwardDocument = this.getSubawardService().createNewSubAwardVersion(subawardDocumentToVersion);
            SubAward subaward = this.getCommonApiService().convertObject(subawardDto, SubAward.class);
            newSubAwardDocument.getSubAward().setOrganizationId(subaward.getOrganizationId());
            newSubAwardDocument.getSubAward().setAccountNumber(subaward.getAccountNumber());
            newSubAwardDocument.getSubAward().setStartDate(subaward.getStartDate());
            newSubAwardDocument.getSubAward().setEndDate(subaward.getEndDate());
            newSubAwardDocument.getSubAward().setSubAwardTypeCode(subaward.getSubAwardTypeCode());
            newSubAwardDocument.getSubAward().setStatusCode(subaward.getStatusCode());
            newSubAwardDocument.getSubAward().setTitle(subaward.getTitle());
            newSubAwardDocument.getSubAward().setRequisitionerId(subaward.getRequisitionerId());
            newSubAwardDocument.getSubAward().setRequisitionerUnit(subaward.getRequisitionerUnit());
            newSubAwardDocument.getSubAward().setVendorNumber(subaward.getVendorNumber());
            newSubAwardDocument.getSubAward().setCloseoutDate(subaward.getCloseoutDate());
            newSubAwardDocument.getSubAward().setArchiveLocation(subaward.getArchiveLocation());
            newSubAwardDocument.getSubAward().setComments(subaward.getComments());
            newSubAwardDocument.getSubAward().setTotalAnticipatedAmount(subaward.getTotalAnticipatedAmount());
            newSubAwardDocument.getSubAward().setTotalObligatedAmount(subaward.getTotalObligatedAmount());
            newSubAwardDocument.getSubAward().setTotalAmountReleased(subaward.getTotalAmountReleased());
            newSubAwardDocument.getSubAward().setTotalAvailableAmount(subaward.getTotalAvailableAmount());
            newSubAwardDocument.getSubAward().setSubAwardContactsList(subawardDto.getSubAwardContactsList().stream().map(contactDto -> {
                SubAwardContact subawardContact = this.commonApiService.convertObject(contactDto, SubAwardContact.class);
                subawardContact.setSubAward(newSubAwardDocument.getSubAward());
                subawardContact.resetPersistenceState();
                this.getCommonApiService().validatePerson(null, subawardContact.getRolodexId());
                return subawardContact;
            }).collect(Collectors.toList()));
            newSubAwardDocument.getSubAward().setSubAwardCustomDataList(subawardDto.getSubAwardCustomDataList().stream().map(customDataDto -> {
                SubAwardCustomData subAwardCustomData = this.commonApiService.convertObject(customDataDto, SubAwardCustomData.class);
                subAwardCustomData.setSubAward(newSubAwardDocument.getSubAward());
                subAwardCustomData.resetPersistenceState();
                return subAwardCustomData;
            }).collect(Collectors.toList()));
            newSubAwardDocument.getSubAward().setSubAwardAmountInfoList(subawardDto.getSubAwardAmountInfoList().stream().map(subAwardAmountInfoDto -> {
                SubAwardAmountInfo subAwardAmountInfo = this.commonApiService.convertObject(subAwardAmountInfoDto, SubAwardAmountInfo.class);
                subAwardAmountInfo.setSubAward(newSubAwardDocument.getSubAward());
                subAwardAmountInfo.resetPersistenceState();
                return subAwardAmountInfo;
            }).collect(Collectors.toList()));
            this.getDocumentService().saveDocument((Document)newSubAwardDocument);
            this.getSubawardService().updateSubAwardSequenceStatus(newSubAwardDocument.getSubAward(), VersionStatus.PENDING);
            return newSubAwardDocument.getDocumentNumber();
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    private void fetchContactType(List<SubAwardContact> contacts) {
        contacts.forEach(contact -> contact.refreshReferenceObject(CONTACT_TYPE));
    }

    private List<SubawardFundingSourceDto> filterFundingSources(List<SubawardFundingSourceDto> fundingSourceDtos, Integer subAwardFundingSourceId) {
        return fundingSourceDtos.stream().filter(fs -> subAwardFundingSourceId.equals(fs.getSubAwardFundingSourceId())).collect(Collectors.toList());
    }

    private void setFundingSourceDetails(SubawardFundingSourceDto subawardFundingSourceDto) {
        subawardFundingSourceDto.setAward(this.commonApiService.convertObject(this.getBusinessObjectService().findBySinglePrimaryKey(Award.class, (Object)subawardFundingSourceDto.getAwardId()), AwardSummaryDto.class));
        if (subawardFundingSourceDto.getAward() != null) {
            subawardFundingSourceDto.setActiveAward(this.commonApiService.convertObject(this.getBusinessObjectService().findBySinglePrimaryKey(Award.class, (Object)this.getActiveAward(subawardFundingSourceDto.getAward().getAwardNumber())), AwardSummaryDto.class));
            subawardFundingSourceDto.setAwardHierarchy(this.commonApiService.convertObject(this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(subawardFundingSourceDto.getAward().getAwardNumber()), AwardHierarchyDto.class));
        }
    }

    private Award getActiveAward(String awardNumber) {
        Map<String, String> criteria = Map.of(AWARD_NUMBER, awardNumber, AWARD_SEQUENCE_STATUS, VersionStatus.ACTIVE.toString());
        return this.getBusinessObjectService().findMatchingOrderBy(Award.class, criteria, SEQUENCE_NUMBER, false).stream().findFirst().orElse(null);
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", SubAward.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", SubAward.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected List<String> getSubawardDtoProperties() throws IntrospectionException {
        return Stream.of(Introspector.getBeanInfo(SubawardDto.class).getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws IntrospectionException {
        this.subawardDtoProperties = this.getSubawardDtoProperties();
    }

    public void setRestAuditLoggerFactory(RestAuditLoggerFactory restAuditLoggerFactory) {
        this.restAuditLoggerFactory = restAuditLoggerFactory;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public void setSubawardService(SubAwardService subawardService) {
        this.subawardService = subawardService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public void setSubawardDtoProperties(List<String> subawardDtoProperties) {
        this.subawardDtoProperties = subawardDtoProperties;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public RestAuditLoggerFactory getRestAuditLoggerFactory() {
        return this.restAuditLoggerFactory;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public SubAwardService getSubawardService() {
        return this.subawardService;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }
}

