/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.cleaning;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.logging.cleaning.LogScrubber;

public class CodecLogScrubber
implements LogScrubber {
    private final Codec<?> customizedMessageCodec;
    private final char[] immuneMessageChars;

    public CodecLogScrubber(Codec<?> messageCodec, char[] immuneChars) {
        if (messageCodec == null) {
            throw new IllegalArgumentException("Codec reference cannot be null");
        }
        this.customizedMessageCodec = messageCodec;
        this.immuneMessageChars = immuneChars == null ? new char[]{} : immuneChars;
    }

    @Override
    public String cleanMessage(String message) {
        return this.customizedMessageCodec.encode(this.immuneMessageChars, message);
    }
}

