/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.service.DataDictionaryRemoteFieldService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.CheckboxGroupControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.GroupControl;
import org.kuali.rice.krad.uif.control.HiddenControl;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UserControl;
import org.kuali.rice.krad.util.DataTypeUtil;

public class DataDictionaryRemoteFieldServiceImpl
implements DataDictionaryRemoteFieldService {
    public RemotableAttributeField buildRemotableFieldFromAttributeDefinition(String componentClassName, String attributeName) {
        RemotableQuickFinder.Builder qf;
        AttributeDefinition baseDefinition;
        Class<?> componentClass;
        try {
            componentClass = Class.forName(componentClassName);
            baseDefinition = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(componentClassName).getAttributeDefinition(attributeName);
        }
        catch (ClassNotFoundException ex) {
            throw new RiceRuntimeException("Unable to find attribute definition for attribute : " + attributeName, (Throwable)ex);
        }
        RemotableAttributeField.Builder definition = RemotableAttributeField.Builder.create((String)baseDefinition.getName());
        definition.setLongLabel(baseDefinition.getLabel());
        definition.setShortLabel(baseDefinition.getShortLabel());
        definition.setMaxLength(baseDefinition.getMaxLength());
        if (baseDefinition.isRequired() != null) {
            definition.setRequired(baseDefinition.isRequired().booleanValue());
        }
        definition.setForceUpperCase(baseDefinition.getForceUppercase().booleanValue());
        String dataType = DataTypeUtil.determineFieldDataType(componentClass, (String)attributeName);
        definition.setDataType(DataType.valueOf((String)dataType.toUpperCase()));
        RemotableAbstractControl.Builder control = this.createControl(baseDefinition);
        if (control != null) {
            definition.setControl(control);
        }
        if ((qf = this.createQuickFinder(componentClass, attributeName)) != null) {
            definition.setWidgets(Collections.singletonList(qf));
        }
        return definition.build();
    }

    protected RemotableAbstractControl.Builder createControl(AttributeDefinition attr) {
        Control control = attr.getControlField();
        if (control != null) {
            if (control instanceof CheckboxControl) {
                return RemotableCheckbox.Builder.create();
            }
            if (control instanceof CheckboxGroupControl) {
                return RemotableCheckboxGroup.Builder.create(this.getValues(attr));
            }
            if (control instanceof HiddenControl) {
                return RemotableHiddenInput.Builder.create();
            }
            if (control instanceof SelectControl) {
                RemotableSelect.Builder b = RemotableSelect.Builder.create(this.getValues(attr));
                b.setMultiple(((SelectControl)control).isMultiple());
                b.setSize(Integer.valueOf(((SelectControl)control).getSize()));
            } else {
                if (control instanceof RadioGroupControl) {
                    return RemotableRadioButtonGroup.Builder.create(this.getValues(attr));
                }
                if (control instanceof TextControl) {
                    RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                    b.setSize(Integer.valueOf(((TextControl)control).getSize()));
                    return b;
                }
                if (control instanceof UserControl) {
                    RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                    b.setSize(Integer.valueOf(((UserControl)control).getSize()));
                    return b;
                }
                if (control instanceof GroupControl) {
                    RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
                    b.setSize(Integer.valueOf(((GroupControl)control).getSize()));
                    return b;
                }
                if (control instanceof TextAreaControl) {
                    RemotableTextarea.Builder b = RemotableTextarea.Builder.create();
                    b.setCols(Integer.valueOf(((TextAreaControl)control).getCols()));
                    b.setRows(Integer.valueOf(((TextAreaControl)control).getRows()));
                    return b;
                }
            }
        }
        return null;
    }

    protected Map<String, String> getValues(AttributeDefinition attr) {
        Control control = attr.getControlField();
        if (control instanceof MultiValueControl && ((MultiValueControl)control).getOptions() != null && !((MultiValueControl)control).getOptions().isEmpty()) {
            List keyValues = ((MultiValueControl)control).getOptions();
            HashMap<String, String> options = new HashMap<String, String>();
            for (KeyValue keyValue : keyValues) {
                options.put(keyValue.getKey(), keyValue.getValue());
            }
            return options;
        }
        if (attr.getOptionsFinder() != null) {
            return attr.getOptionsFinder().getKeyLabelMap();
        }
        return Collections.emptyMap();
    }

    protected RemotableQuickFinder.Builder createQuickFinder(Class<?> componentClass, String attributeName) {
        return this.getLegacyDataAdapter().createQuickFinder(componentClass, attributeName);
    }

    protected DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    protected ConfigurationService getKualiConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        return KRADServiceLocatorWeb.getLegacyDataAdapter();
    }
}

