/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom.attr;

import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;

public class CustomAttributeDocumentMaintainableImpl
extends KualiMaintainableImpl {
    public void prepareForSave() {
        CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)this.getBusinessObject();
        boolean needsTranslated = true;
        int val = 0;
        try {
            val = Integer.parseInt(customAttributeDocument.getDocumentTypeName());
            needsTranslated = true;
        }
        catch (Exception e) {
            needsTranslated = false;
        }
        if (needsTranslated) {
            customAttributeDocument.setDocumentTypeName(this.convertModuleNumberToDocumentTypeCode(val));
        }
        super.prepareForSave();
    }

    public String convertModuleNumberToDocumentTypeCode(int moduleNumber) {
        String documentTypeCode;
        switch (moduleNumber) {
            case 1: {
                documentTypeCode = "AWRD";
                break;
            }
            case 2: {
                documentTypeCode = "INPR";
                break;
            }
            case 3: {
                documentTypeCode = "PRDV";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid typeName provided: " + moduleNumber);
            }
        }
        return documentTypeCode;
    }
}

