/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="questionService")
public class QuestionServiceImpl
implements QuestionService {
    private static final String QUESTION_QUESTION_ID = "questionnaireQuestions.question.questionSeqId";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public Question getQuestionByQuestionId(Long questionId) {
        Question question = null;
        if (questionId != null) {
            HashMap<String, Long> fieldValues = new HashMap<String, Long>();
            fieldValues.put("id", questionId);
            question = (Question)this.businessObjectService.findByPrimaryKey(Question.class, fieldValues);
        }
        return question;
    }

    @Override
    public Question getQuestionByQuestionSequenceId(Integer questionSeqId) {
        Question question = null;
        if (questionSeqId != null) {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("questionSeqId", questionSeqId);
            Collection questions = this.businessObjectService.findMatching(Question.class, fieldValues);
            if (questions.size() > 0) {
                question = (Question)Collections.max(questions);
            }
        }
        return question;
    }

    @Override
    public boolean isQuestionUsed(Integer questionId) {
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put(QUESTION_QUESTION_ID, questionId);
        List questionnaires = (List)this.businessObjectService.findMatching(Questionnaire.class, fieldValues);
        for (Questionnaire questionnaire : questionnaires) {
            if (!this.isActiveQuestionnaire(questionnaire)) continue;
            return true;
        }
        return false;
    }

    protected boolean isActiveQuestionnaire(Questionnaire questionnaire) {
        Questionnaire maxQuestionnaire;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionnaireSeqId", questionnaire.getQuestionnaireSeqId());
        Collection questionnaires = this.businessObjectService.findMatching(Questionnaire.class, fieldValues);
        return questionnaires.size() > 0 && (maxQuestionnaire = (Questionnaire)Collections.max(questionnaires)).getId().equals(questionnaire.getId());
    }
}

