/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

function setIframeAnchor(iframeName) {
  var iframeWin = window.frames[iframeName];
  try {
    // For security reasons the browsers will not allow cross server scripts and
    // throw an exception instead.
    // Note that bad browsers (e.g. google chrome) will not catch the exception
    if (iframeWin && iframeWin.location.href.indexOf("#") > -1) {
      iframeWin.location.replace(iframeWin.location);
    }
  }
  catch (e) {
      // ignoring error
  }
}

function jumpToAnchorName(anchor){
	var anchors = document.getElementsByName(anchor);
	if (anchors != null)
		location.href = '#'+anchors[0].name;
}
