
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="property" required="true" description="The property associated that should have a date input rendered for it." %>
<%@ attribute name="size" required="true" description="The size of the HTML text field rendered for this date input." %>
<%@ attribute name="maxLength" required="true" description="The maximum length of the input the HTML text field rendered for this date input will hold." %>

<%@ attribute name="accessibilityHint" required="false"
        description="Use this to attach further information to the title attribute of a field
        if present"%>

<kul:checkErrors keyMatch="${property}"/>

<c:choose>
	<c:when test="${!empty accessibilityHint}">
		<html:text property="${property}" styleId="${property}" size="${size}" maxlength="${maxLength}" style="${textStyle}" alt="${accessibilityHint}" title="${accessibilityHint}" />
	</c:when>
	<c:otherwise>
		<html:text property="${property}" styleId="${property}" size="${size}" maxlength="${maxLength}" style="${textStyle}"/>
	</c:otherwise>
</c:choose>
<c:if test="${hasErrors==true}">
  <kul:fieldShowErrorIcon />
</c:if>
<img src="${ConfigProperties.kr.externalizable.images.url}cal.gif" id="${property}_datepicker" style="cursor: pointer;" alt="Date selector" title="Date selector" onmouseover="this.style.background='#F00';" onmouseout="this.style.background='#FFF';" />    
<script type="text/javascript">
	Calendar.setup(
	{
    	inputField : "${property}", // ID of the input field
    	ifFormat : "%m/%d/%Y", // the date format
    	button : "${property}_datepicker" // ID of the button
    }
    );
</script>

