
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<%@ attribute name="includeDocumentHeaderFields" required="false" description="Whether to include the document number as a hidden field." %>
<%@ attribute name="includeEditMode" required="false" description="Whether to include the current edit modes as hidden fields." %>

<c:set var="documentTypeName" value="${KualiForm.docTypeName}" />
<c:set var="documentEntry" value="${DataDictionary[documentTypeName]}" />

<%-- set default values --%>
<c:if test="${empty includeDocumentHeaderFields}">
    <c:set var="includeDocumentHeaderFields" value="true" />
</c:if>
<c:if test="${empty includeEditMode}">
    <c:set var="includeEditMode" value="true" />
</c:if>

<html:hidden property="docId" />
<html:hidden property="document.documentNumber" />

<c:if test="${includeDocumentHeaderFields}">
  <html:hidden property="document.documentHeader.documentNumber" />  
</c:if>
<c:if test="${includeEditMode}">
    <c:forEach items="${KualiForm.editingMode}" var="mode">
      <html:hidden property="editingMode(${mode.key})"/>
    </c:forEach>
</c:if>
