/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.copy;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ehcache.Cache;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.Ehcache;
import org.ehcache.core.spi.store.AbstractWrapperStoreProvider;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.impl.internal.spi.copy.DefaultCopyProvider;
import org.ehcache.impl.internal.store.copy.CopyingIterable;
import org.ehcache.impl.internal.store.copy.ImmutableCopyingMap;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;

public class CopierStore<K, V>
implements Store<K, V> {
    private final Copier<K> keyCopier;
    private final Copier<V> valueCopier;
    private final Store<K, V> delegate;

    public CopierStore(Copier<K> keyCopier, Copier<V> valueCopier, Store<K, V> delegate) {
        this.keyCopier = keyCopier;
        this.valueCopier = valueCopier;
        this.delegate = delegate;
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.get(key));
    }

    public boolean containsKey(K key) throws StoreAccessException {
        return this.delegate.containsKey(key);
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        return this.delegate.put(this.keyCopier.copyForWrite(key), this.valueCopier.copyForWrite(value));
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.putIfAbsent(this.keyCopier.copyForWrite(key), this.valueCopier.copyForWrite(value), put));
    }

    public boolean remove(K key) throws StoreAccessException {
        return this.delegate.remove(key);
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        return this.delegate.remove(key, value);
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.replace(key, this.valueCopier.copyForWrite(value)));
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        return this.delegate.replace(key, oldValue, this.valueCopier.copyForWrite(newValue));
    }

    public void clear() throws StoreAccessException {
        this.delegate.clear();
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.delegate.getStoreEventSource();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        final Store.Iterator iterator = this.delegate.iterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
                final Cache.Entry next = (Cache.Entry)iterator.next();
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return CopierStore.this.keyCopier.copyForRead(next.getKey());
                    }

                    public Store.ValueHolder<V> getValue() {
                        return CopierStore.this.copyValueForRead((Store.ValueHolder)next.getValue());
                    }
                };
            }
        };
    }

    public Store.ValueHolder<V> getAndPut(K key, V value) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.getAndPut(this.keyCopier.copyForWrite(key), this.valueCopier.copyForWrite(value)));
    }

    public Store.ValueHolder<V> getAndRemove(K key) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.getAndRemove(key));
    }

    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.getAndCompute(key, (k, v) -> this.valueCopier.copyForWrite(mappingFunction.apply((K)this.keyCopier.copyForRead(k), (V)this.valueCopier.copyForRead(v)))));
    }

    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.computeAndGet(key, (k, v) -> this.valueCopier.copyForWrite(mappingFunction.apply((K)this.keyCopier.copyForRead(k), (V)this.valueCopier.copyForRead(v))), replaceEqual, invokeWriter));
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.copyValueForRead(this.delegate.computeIfAbsent(this.keyCopier.copyForWrite(key), k -> this.valueCopier.copyForWrite(mappingFunction.apply((K)this.keyCopier.copyForRead(k)))));
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        if (remappingFunction instanceof Ehcache.RemoveAllFunction) {
            return this.copyForRead(this.delegate.bulkCompute(keys, remappingFunction));
        }
        if (remappingFunction instanceof Ehcache.PutAllFunction) {
            final Ehcache.PutAllFunction putAllFunction = (Ehcache.PutAllFunction)remappingFunction;
            return this.copyForRead(this.delegate.bulkCompute(keys, (Function)new Ehcache.PutAllFunction<K, V>(){

                public Map<K, V> getEntriesToRemap() {
                    return CopierStore.this.copyForWrite(putAllFunction.getEntriesToRemap());
                }

                public boolean newValueAlreadyExpired(K key, V oldValue, V newValue) {
                    return putAllFunction.newValueAlreadyExpired(key, oldValue, newValue);
                }

                public AtomicInteger getActualPutCount() {
                    return putAllFunction.getActualPutCount();
                }

                public AtomicInteger getActualUpdateCount() {
                    return putAllFunction.getActualUpdateCount();
                }
            }));
        }
        return this.copyForRead(this.delegate.bulkCompute(keys, entries -> this.copyForWrite((Iterable)remappingFunction.apply(this.copyForRead((Iterable<? extends Map.Entry<? extends K, ? extends V>>)entries)))));
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) throws StoreAccessException {
        return this.copyForRead(this.delegate.bulkCompute(keys, entries -> this.copyForWrite((Iterable)remappingFunction.apply(this.copyForRead((Iterable<? extends Map.Entry<? extends K, ? extends V>>)entries))), replaceEqual));
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        if (mappingFunction instanceof Ehcache.GetAllFunction) {
            return this.copyForRead(this.delegate.bulkComputeIfAbsent(keys, mappingFunction));
        }
        return this.copyForRead(this.delegate.bulkComputeIfAbsent(this.copyKeysForWrite(keys), ks -> this.copyForWrite((Iterable)mappingFunction.apply(this.copyKeysForRead((Iterable<? extends K>)ks)))));
    }

    private Set<? extends K> copyKeysForWrite(Set<? extends K> keys) {
        return keys.stream().map(arg_0 -> this.keyCopier.copyForWrite(arg_0)).collect(Collectors.toSet());
    }

    private Iterable<? extends K> copyKeysForRead(Iterable<? extends K> keys) {
        return new CopyingIterable<Object, Object>(keys, arg_0 -> this.keyCopier.copyForRead(arg_0));
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return this.delegate.getConfigurationChangeListeners();
    }

    private Store.ValueHolder<V> copyValueForRead(final Store.ValueHolder<V> valueHolder) {
        if (valueHolder == null) {
            return null;
        }
        return new Store.ValueHolder<V>(){

            public long creationTime() {
                return valueHolder.creationTime();
            }

            public long expirationTime() {
                return valueHolder.expirationTime();
            }

            public boolean isExpired(long expirationTime) {
                return valueHolder.isExpired(expirationTime);
            }

            public long lastAccessTime() {
                return valueHolder.lastAccessTime();
            }

            public long getId() {
                return valueHolder.getId();
            }

            @Nonnull
            public V get() {
                return CopierStore.this.valueCopier.copyForRead(valueHolder.get());
            }
        };
    }

    private Map<K, Store.ValueHolder<V>> copyForRead(Map<K, Store.ValueHolder<V>> entries) {
        return new ImmutableCopyingMap<K, Store.ValueHolder<V>>(entries, arg_0 -> this.keyCopier.copyForRead(arg_0), this::copyValueForRead);
    }

    private Iterable<? extends Map.Entry<? extends K, ? extends V>> copyForRead(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        return new CopyingIterable<Map.Entry, AbstractMap.SimpleImmutableEntry>(entries, e -> new AbstractMap.SimpleImmutableEntry<Object, Object>(this.keyCopier.copyForRead(e.getKey()), this.valueCopier.copyForRead(e.getValue())));
    }

    private Map<K, V> copyForWrite(Map<K, V> entries) {
        return new ImmutableCopyingMap<K, V>(entries, arg_0 -> this.keyCopier.copyForWrite(arg_0), arg_0 -> this.valueCopier.copyForWrite(arg_0));
    }

    private Iterable<? extends Map.Entry<K, ? extends V>> copyForWrite(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        return new CopyingIterable<Map.Entry, AbstractMap.SimpleImmutableEntry>(entries, e -> new AbstractMap.SimpleImmutableEntry<Object, Object>(this.keyCopier.copyForWrite(e.getKey()), this.valueCopier.copyForWrite(e.getValue())));
    }

    @ServiceDependencies(value={DefaultCopyProvider.class})
    public static class Provider
    extends AbstractWrapperStoreProvider {
        private CopyProvider copyProvider;

        public Provider() {
            super(new Class[0]);
        }

        protected int wrapperRank() {
            return 3;
        }

        protected <K, V> Store<K, V> wrap(Store<K, V> store, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            Copier keyCopier = this.copyProvider.createKeyCopier(storeConfig.getKeyType(), storeConfig.getKeySerializer(), serviceConfigs);
            Copier valueCopier = this.copyProvider.createValueCopier(storeConfig.getValueType(), storeConfig.getValueSerializer(), serviceConfigs);
            if (keyCopier instanceof IdentityCopier && valueCopier instanceof IdentityCopier) {
                return store;
            }
            return new CopierStore<K, V>(keyCopier, valueCopier, store);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseStore(Store<?, ?> resource) {
            block8: {
                try {
                    if (!(resource instanceof CopierStore)) break block8;
                    try {
                        CopierStore copierStore = (CopierStore)resource;
                        try {
                            this.copyProvider.releaseCopier(copierStore.keyCopier);
                        }
                        finally {
                            this.copyProvider.releaseCopier(copierStore.valueCopier);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    super.releaseStore(resource);
                }
            }
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            super.start(serviceProvider);
            this.copyProvider = (CopyProvider)serviceProvider.getService(CopyProvider.class);
        }
    }
}

