/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.authoritative;

import java.util.Collection;
import java.util.Set;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.AbstractSharedTierProvider;
import org.ehcache.impl.internal.store.shared.authoritative.AuthoritativeTierPartition;
import org.ehcache.spi.service.ServiceConfiguration;

public class SharedAuthoritativeTierProvider
extends AbstractSharedTierProvider
implements AuthoritativeTier.Provider {
    public int rankAuthority(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        return this.rank(AuthoritativeTier.class, resourceTypes);
    }

    public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Set<ResourceType<?>> resourceTypes, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        ResourceType.SharedResource<?> resourceType = SharedAuthoritativeTierProvider.assertResourceIsShareable(resourceTypes);
        String alias = this.extractAlias(serviceConfigs);
        return this.sharedStorageProvider.partition(alias, resourceType.getResourceType(), storeConfig, (id, store, storage) -> {
            AuthoritativeTierPartition partition = new AuthoritativeTierPartition((ResourceType<?>)resourceType.getResourceType(), id, storeConfig.getKeyType(), storeConfig.getValueType(), store);
            this.associateStoreStatsWithPartition(store, partition);
            return partition;
        });
    }

    public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
        AbstractPartition partition = (AbstractPartition)resource;
        this.sharedStorageProvider.releasePartition(partition);
    }

    public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
    }
}

